/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ModelCheckingOptions {
    public static ModelCheckingOptions DEFAULT = new ModelCheckingOptions().checkDeadlocks(true).checkInvariantViolations(true);
    private final EnumSet<Options> options;

    public ModelCheckingOptions() {
        this.options = EnumSet.noneOf(Options.class);
    }

    private ModelCheckingOptions(EnumSet<Options> options) {
        this.options = options;
    }

    public ModelCheckingOptions breadthFirst(boolean value) {
        return this.changeOption(value, Options.breadth_first_search);
    }

    public ModelCheckingOptions checkDeadlocks(boolean value) {
        return this.changeOption(value, Options.find_deadlocks);
    }

    public ModelCheckingOptions checkInvariantViolations(boolean value) {
        return this.changeOption(value, Options.find_invariant_violations);
    }

    public ModelCheckingOptions checkAssertions(boolean value) {
        return this.changeOption(value, Options.find_assertion_violations);
    }

    public ModelCheckingOptions recheckExisting(boolean value) {
        return this.changeOption(value, Options.inspect_existing_nodes);
    }

    public ModelCheckingOptions stopAtFullCoverage(boolean value) {
        return this.changeOption(value, Options.stop_at_full_coverage);
    }

    public ModelCheckingOptions partialOrderReduction(boolean value) {
        return this.changeOption(value, Options.partial_order_reduction);
    }

    public ModelCheckingOptions partialGuardEvaluation(boolean value) {
        return this.changeOption(value, Options.partial_guard_evaluation);
    }

    public ModelCheckingOptions checkGoal(boolean value) {
        return this.changeOption(value, Options.find_goal);
    }

    private ModelCheckingOptions changeOption(boolean value, Options o) {
        if (value == this.options.contains((Object)o)) {
            return this;
        }
        EnumSet<Options> copyOf = EnumSet.copyOf(this.options);
        if (value) {
            copyOf.add(o);
        } else {
            copyOf.remove((Object)o);
        }
        return new ModelCheckingOptions(copyOf);
    }

    public Set<Options> getPrologOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public String toString() {
        return this.options.toString();
    }

    public static enum Options {
        breadth_first_search("breadth first"),
        find_deadlocks("deadlock check"),
        find_invariant_violations("invariant check"),
        find_assertion_violations("assertion check"),
        inspect_existing_nodes("recheck existing states"),
        stop_at_full_coverage("stop at full coverage"),
        partial_order_reduction("partial order reduction"),
        partial_guard_evaluation("partial guard evaluation"),
        find_goal("search for goal");

        private final String description;

        private Options(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

