/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.animator.domainobjects.EvalElementType;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetOperationByPredicateCommand
extends AbstractCommand
implements IStateSpaceModifier {
    private static final String PROLOG_COMMAND_NAME = "prob2_execute_custom_operations";
    Logger logger = LoggerFactory.getLogger(GetOperationByPredicateCommand.class);
    private static final String NEW_STATE_ID_VARIABLE = "NewStateID";
    private static final String ERRORS = "Errors";
    private final IEvalElement evalElement;
    private final String stateId;
    private final String name;
    private final List<Transition> operations = new ArrayList<Transition>();
    private final List<String> errors = new ArrayList<String>();
    private final int nrOfSolutions;
    private final StateSpace s;

    public GetOperationByPredicateCommand(StateSpace s, String stateId, String name, IEvalElement predicate, int nrOfSolutions) {
        this.s = s;
        this.stateId = stateId;
        this.name = name;
        this.nrOfSolutions = nrOfSolutions;
        this.evalElement = predicate;
        if (!this.evalElement.getKind().equals(EvalElementType.PREDICATE.toString())) {
            throw new IllegalArgumentException("Formula must be a predicate: " + predicate);
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printAtomOrNumber(this.stateId).printAtom(this.name);
        this.evalElement.printProlog(pto);
        pto.printNumber((long)this.nrOfSolutions);
        pto.printVariable(NEW_STATE_ID_VARIABLE);
        pto.printVariable(ERRORS).closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm list = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)NEW_STATE_ID_VARIABLE)));
        for (PrologTerm prologTerm : list) {
            CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)prologTerm, (int)4);
            this.operations.add(Transition.createTransitionFromCompoundPrologTerm(this.s, cpt));
        }
        ListPrologTerm errors = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)ERRORS)));
        for (PrologTerm prologTerm : errors) {
            this.errors.add(prologTerm.getFunctor());
        }
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.operations;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

