/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetEnabledOperationsCommand
extends AbstractCommand
implements IStateSpaceModifier {
    private static final String PROLOG_COMMAND_NAME = "compute_operations_for_state";
    Logger logger = LoggerFactory.getLogger(GetEnabledOperationsCommand.class);
    private static final String OPERATIONS_VARIABLE = "PLOps";
    private final String id;
    private List<Transition> enabledOperations = Collections.emptyList();
    private final StateSpace s;

    public GetEnabledOperationsCommand(StateSpace s, String id) {
        this.s = s;
        this.id = id;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        this.enabledOperations = new ArrayList<Transition>();
        ListPrologTerm prologTerm = (ListPrologTerm)bindings.get((Object)OPERATIONS_VARIABLE);
        for (PrologTerm op : prologTerm) {
            CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)op, (int)4);
            this.enabledOperations.add(Transition.createTransitionFromCompoundPrologTerm(this.s, cpt));
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtomOrNumber(this.id);
        pto.printVariable(OPERATIONS_VARIABLE);
        pto.closeTerm();
    }

    public List<Transition> getEnabledOperations() {
        return this.enabledOperations;
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.enabledOperations;
    }
}

