/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.util.FP64;
import tlc2.value.Enumerable;
import tlc2.value.IntValue;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.Reducible;
import tlc2.value.SetCupValue;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;

public class IntervalValue
extends Value
implements Enumerable,
Reducible {
    public int low;
    public int high;

    public IntervalValue(int low, int high) {
        this.low = low;
        this.high = high;
    }

    @Override
    public final byte getKind() {
        return 23;
    }

    @Override
    public final int compareTo(Object obj) {
        if (obj instanceof IntervalValue) {
            IntervalValue intv = (IntervalValue)obj;
            int cmp = this.size() - intv.size();
            if (cmp != 0) {
                return cmp;
            }
            if (this.size() == 0) {
                return 0;
            }
            return this.low - intv.low;
        }
        return SetEnumValue.convert(this).compareTo(obj);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof IntervalValue) {
            IntervalValue intv = (IntervalValue)obj;
            if (this.size() == 0) {
                return intv.size() == 0;
            }
            return this.low == intv.low && this.high == intv.high;
        }
        return SetEnumValue.convert(this).equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        if (elem instanceof IntValue) {
            int x = ((IntValue)elem).val;
            return x >= this.low && x <= this.high;
        }
        if (!(this.low > this.high || elem instanceof ModelValue && ((ModelValue)elem).type == '\u0000')) {
            Assert.fail("Attempted to check if the value:\n" + IntervalValue.ppr(elem.toString()) + "\nis in the integer interval " + IntervalValue.ppr(this.toString()));
        }
        return false;
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final int size() {
        if (this.high < this.low) {
            return 0;
        }
        return this.high - this.low + 1;
    }

    @Override
    public final Value diff(Value val) {
        ValueVec diffElems = new ValueVec();
        for (int i = this.low; i <= this.high; ++i) {
            IntValue elem = IntValue.gen(i);
            if (val.member(elem)) continue;
            diffElems.addElement(elem);
        }
        return new SetEnumValue(diffElems, true);
    }

    @Override
    public final Value cap(Value val) {
        ValueVec capElems = new ValueVec();
        for (int i = this.low; i <= this.high; ++i) {
            IntValue elem = IntValue.gen(i);
            if (!val.member(elem)) continue;
            capElems.addElement(elem);
        }
        return new SetEnumValue(capElems, true);
    }

    @Override
    public final Value cup(Value set) {
        if (this.size() == 0) {
            return set;
        }
        if (set instanceof Reducible) {
            Value elem;
            ValueVec cupElems = new ValueVec();
            for (int i = this.low; i <= this.high; ++i) {
                cupElems.addElement(IntValue.gen(i));
            }
            ValueEnumeration Enum2 = ((Enumerable)((Object)set)).elements();
            while ((elem = Enum2.nextElement()) != null) {
                if (this.member(elem)) continue;
                cupElems.addElement(elem);
            }
            return new SetEnumValue(cupElems, false);
        }
        return new SetCupValue(this, set);
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (ex.idx < ex.path.length) {
            Assert.fail("Attempted to apply EXCEPT construct to the interval value " + IntervalValue.ppr(this.toString()) + ".");
        }
        return ex.value;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (exs.length != 0) {
            Assert.fail("Attempted to apply EXCEPT construct to the interval value " + IntervalValue.ppr(this.toString()) + ".");
        }
        return this;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final void normalize() {
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        return val instanceof IntervalValue && this.high == ((IntervalValue)val).high && this.low == ((IntervalValue)val).low;
    }

    @Override
    public final long fingerPrint(long fp) {
        fp = FP64.Extend(fp, (byte)5);
        fp = FP64.Extend(fp, this.size());
        for (int i = this.low; i <= this.high; ++i) {
            fp = FP64.Extend(fp, (byte)1);
            fp = FP64.Extend(fp, i);
        }
        return fp;
    }

    @Override
    public final Value permute(MVPerm perm) {
        return this;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        if (this.low <= this.high) {
            return sb.append(this.low).append("..").append(this.high);
        }
        return sb.append("{").append("}");
    }

    @Override
    public final ValueEnumeration elements() {
        return new Enumerator();
    }

    final class Enumerator
    implements ValueEnumeration {
        int index;

        Enumerator() {
            this.index = IntervalValue.this.low;
        }

        @Override
        public final void reset() {
            this.index = IntervalValue.this.low;
        }

        @Override
        public final Value nextElement() {
            if (this.index <= IntervalValue.this.high) {
                return IntValue.gen(this.index++);
            }
            return null;
        }
    }
}

