/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import tlc2.tool.liveness.AbstractGraphNode;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.util.BitVector;
import tlc2.util.BufferedRandomAccessFile;

public class GraphNode
extends AbstractGraphNode {
    private static final int[] emptyIntArr = new int[0];
    final long stateFP;
    private int[] nnodes;
    final int tindex;
    private int offset = -1;

    public GraphNode(long fp, int tindex) {
        this(fp, tindex, emptyIntArr, new BitVector(0));
    }

    private GraphNode(long fp, int tindex, int[] nnodes, BitVector checks) {
        super(checks);
        this.stateFP = fp;
        this.tindex = tindex;
        this.nnodes = nnodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.stateFP ^ this.stateFP >>> 32);
        result = 31 * result + this.tindex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        if (this.stateFP != other.stateFP) {
            return false;
        }
        return this.tindex == other.tindex;
    }

    public final long getStateFP(int i) {
        long high = this.nnodes[3 * i];
        long low = this.nnodes[3 * i + 1];
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final int getTidx(int i) {
        return this.nnodes[3 * i + 2];
    }

    public final int succSize() {
        if (this.offset != -1) {
            return this.offset / 3;
        }
        return this.nnodes.length / 3;
    }

    private final void allocate(int transitions) {
        int len = this.nnodes.length;
        int[] newNodes = new int[len + 3 * transitions];
        System.arraycopy(this.nnodes, 0, newNodes, 0, len);
        this.nnodes = newNodes;
        this.offset = len;
    }

    public final void addTransition(long fp, int tidx, int slen, int alen, BitVector acts, int actsOffset, int allocationHint) {
        if (acts != null) {
            int pos = slen + alen * this.succSize();
            for (int i = 0; i < alen; ++i) {
                if (!acts.get(actsOffset + i)) continue;
                this.checks.set(pos + i);
            }
        }
        if (this.offset == -1) {
            this.allocate(Math.max(allocationHint, 1));
        }
        this.nnodes[this.offset] = (int)(fp >>> 32);
        this.nnodes[this.offset + 1] = (int)(fp & 0xFFFFFFFFL);
        this.nnodes[this.offset + 2] = tidx;
        this.offset += 3;
        if (this.offset == this.nnodes.length) {
            this.offset = -1;
        }
    }

    public int realign() {
        int result = 0;
        if (this.offset != -1) {
            result = (this.nnodes.length - this.offset) / 3;
            int[] newNodes = new int[this.offset];
            System.arraycopy(this.nnodes, 0, newNodes, 0, newNodes.length);
            this.nnodes = newNodes;
            this.offset = -1;
        }
        return result;
    }

    public final boolean transExists(long fp, int tidx) {
        int len = this.nnodes.length;
        if (this.offset != -1) {
            len = this.offset;
        }
        int high = (int)(fp >>> 32);
        int low = (int)(fp & 0xFFFFFFFFL);
        for (int i = 0; i < len; i += 3) {
            if (this.nnodes[i] != high || this.nnodes[i + 1] != low || this.nnodes[i + 2] != tidx) continue;
            return true;
        }
        return false;
    }

    public final TBGraphNode getTNode(TBGraph tableau) {
        return tableau.getNode(this.tindex);
    }

    void write(BufferedRandomAccessFile nodeRAF) throws IOException {
        int cnt = this.nnodes.length;
        nodeRAF.writeNat(cnt);
        for (int i = 0; i < cnt; ++i) {
            nodeRAF.writeInt(this.nnodes[i]);
        }
        this.checks.write(nodeRAF);
    }

    void read(BufferedRandomAccessFile nodeRAF) throws IOException {
        int cnt = nodeRAF.readNat();
        this.nnodes = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.nnodes[i] = nodeRAF.readInt();
        }
        this.checks = new BitVector();
        this.checks.read(nodeRAF);
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.stateFP + "," + this.tindex + "> --> ");
        int size = this.nnodes.length;
        if (size != 0) {
            long high = this.nnodes[0];
            long low = this.nnodes[1];
            long fp = high << 32 | low & 0xFFFFFFFFL;
            buf.append("<" + fp + "," + this.nnodes[2] + ">");
        }
        for (int i = 3; i < size; i += 3) {
            buf.append(", ");
            long high = this.nnodes[i];
            long low = this.nnodes[i + 1];
            long fp = high << 32 | low & 0xFFFFFFFFL;
            buf.append("<" + fp + "," + this.nnodes[i + 2] + ">");
        }
        return buf.toString();
    }

    public String toDotViz(boolean isInitState, boolean hasTableau) {
        String id = ("" + this.stateFP).substring(0, 3);
        if (hasTableau) {
            id = id + "." + this.tindex;
        }
        StringBuffer buf = new StringBuffer();
        if (isInitState) {
            buf.append(id + " [style = filled]\n");
        }
        int size = this.nnodes.length;
        for (int i = 0; i < size; i += 3) {
            buf.append(id + " -> ");
            long high = this.nnodes[i];
            long low = this.nnodes[i + 1];
            long fp = high << 32 | low & 0xFFFFFFFFL;
            if (hasTableau) {
                buf.append(("" + fp).substring(0, 3) + "." + this.nnodes[i + 2]);
            } else {
                buf.append(("" + fp).substring(0, 3));
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

