/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.CheckImpl;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.util.FP64;
import util.Assert;
import util.FileUtil;
import util.ToolIO;
import util.UniqueString;

public class CheckImplFile
extends CheckImpl {
    private static int WaitForTrace = 10000;
    private TLCState[] states;
    private int sidx;
    private String traceFile;
    private int ticnt;
    private int tocnt;

    public CheckImplFile(String specFile, String configFile, boolean deadlock, int depth, String fromChkpt, String traceFile, FPSetConfiguration fpSetConfig) throws IOException {
        super(specFile, configFile, deadlock, depth, fromChkpt, fpSetConfig);
        this.traceFile = traceFile;
        this.states = null;
        this.sidx = 0;
        this.ticnt = 1;
        this.tocnt = 1;
    }

    @Override
    public final TLCState getState() {
        if (this.sidx < this.states.length) {
            return this.states[this.sidx++];
        }
        return null;
    }

    @Override
    public final void exportTrace(TLCStateInfo[] trace) throws IOException {
        String fname = this.traceFile + "_out_" + this.tocnt;
        FileOutputStream fos = new FileOutputStream(fname);
        PrintWriter pw = new PrintWriter(fos);
        for (int i = 0; i < trace.length; ++i) {
            pw.println("STATE_" + (i + 1));
            pw.println(trace[i].state + "\n");
        }
        pw.close();
        ++this.tocnt;
    }

    public final boolean getTrace() {
        String rfname = this.traceFile + this.ticnt;
        File tfile = new File(rfname);
        ToolIO.out.println("Trying to work on trace " + tfile + " ...");
        if (!tfile.exists()) {
            return false;
        }
        SpecObj spec = new SpecObj(rfname, null);
        try {
            SANY.frontEndInitialize(spec, ToolIO.out);
            SANY.frontEndParse(spec, ToolIO.out);
            SANY.frontEndSemanticAnalysis(spec, ToolIO.out, true);
        }
        catch (Throwable e) {
            String msg = e.getMessage() == null ? e.toString() : e.getMessage();
            Assert.fail(3001, msg);
        }
        if (!(spec.initErrors.isSuccess() && spec.parseErrors.isSuccess() && spec.semanticErrors.isSuccess())) {
            Assert.fail(3002);
        }
        ExternalModuleTable mt = spec.getExternalModuleTable();
        ModuleNode module = mt.getModuleNode(UniqueString.uniqueStringOf(rfname));
        OpDefNode[] opDefs = module.getOpDefs();
        int len = opDefs.length;
        this.states = new TLCState[len];
        for (int i = 0; i < len; ++i) {
            TLCState state;
            this.states[i] = state = this.tool.makeState(opDefs[i].getBody());
        }
        this.sidx = 0;
        ++this.ticnt;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        ToolIO.out.println("TLC CheckImpl" + TLCGlobals.versionOfTLC);
        String mainFile = null;
        String configFile = null;
        String traceFile = null;
        boolean deadlock = true;
        int depth = 20;
        String fromChkpt = null;
        int index = 0;
        while (index < args.length) {
            int len;
            if (args[index].equals("-config")) {
                if (++index >= args.length) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3100));
                    return;
                }
                len = configFile.length();
                if (!(configFile = args[index++]).startsWith(".cfg", len - 4)) continue;
                configFile = configFile.substring(0, len - 4);
                continue;
            }
            if (args[index].equals("-deadlock")) {
                ++index;
                deadlock = false;
                continue;
            }
            if (args[index].equals("-recover")) {
                if (++index >= args.length) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3103));
                    return;
                }
                fromChkpt = args[index++] + FileUtil.separator;
                continue;
            }
            if (args[index].equals("-workers")) {
                if (++index >= args.length) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3106));
                    return;
                }
                try {
                    TLCGlobals.setNumWorkers(Integer.parseInt(args[index]));
                    ++index;
                }
                catch (NumberFormatException e) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3104, args[index]));
                    return;
                }
                if (TLCGlobals.getNumWorkers() >= 1) continue;
                CheckImplFile.printErrorMsg(MP.getMessage(3105));
                return;
            }
            if (args[index].equals("-depth")) {
                if (++index >= args.length) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3108));
                    return;
                }
                try {
                    depth = Integer.parseInt(args[index]);
                    ++index;
                    continue;
                }
                catch (NumberFormatException e) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3107, args[index]));
                    return;
                }
            }
            if (args[index].equals("-trace")) {
                if (++index >= args.length) {
                    CheckImplFile.printErrorMsg(MP.getMessage(3109));
                    return;
                }
                traceFile = args[index++];
                continue;
            }
            if (args[index].equals("-coverage")) {
                if (++index >= args.length) {
                    CheckImplFile.printErrorMsg(MP.getError(3110));
                    return;
                }
                try {
                    TLCGlobals.coverageInterval = Integer.parseInt(args[index]) * 1000 * 60;
                    if (TLCGlobals.coverageInterval < 0) {
                        CheckImplFile.printErrorMsg(MP.getMessage(3112));
                        return;
                    }
                    ++index;
                    continue;
                }
                catch (NumberFormatException e) {
                    CheckImplFile.printErrorMsg(MP.getError(3110, args[index]));
                    return;
                }
            }
            if (args[index].charAt(0) == '-') {
                CheckImplFile.printErrorMsg(MP.getError(3113, args[index]));
                return;
            }
            if (mainFile != null) {
                CheckImplFile.printErrorMsg(MP.getError(3113, new String[]{mainFile, args[index]}));
                return;
            }
            len = mainFile.length();
            if (!(mainFile = args[index++]).startsWith(".tla", len - 4)) continue;
            mainFile = mainFile.substring(0, len - 4);
        }
        if (mainFile == null) {
            CheckImplFile.printErrorMsg(MP.getMessage(3102));
            return;
        }
        if (configFile == null) {
            configFile = mainFile;
        }
        if (traceFile == null) {
            traceFile = mainFile + "_trace";
        }
        try {
            if (fromChkpt != null) {
                UniqueString.internTbl.recover(fromChkpt);
            }
            FP64.Init(0);
            CheckImplFile checker = new CheckImplFile(mainFile, configFile, deadlock, depth, fromChkpt, traceFile, new FPSetConfiguration());
            checker.init();
            while (true) {
                checker.export();
                boolean ok = checker.getTrace();
                if (ok) {
                    checker.checkTrace();
                    continue;
                }
                CheckImplFile checkImplFile = checker;
                synchronized (checkImplFile) {
                    checker.wait(WaitForTrace);
                }
            }
        }
        catch (Throwable e) {
            MP.printError(3000, e);
            System.exit(0);
            return;
        }
    }

    private static void printErrorMsg(String msg) {
        ToolIO.out.println(msg);
        MP.printError(3101);
    }
}

