/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.spockframework.builder.DelegatingScript;
import org.spockframework.runtime.GroovyRuntimeUtil;
import spock.config.ConfigurationException;

public class ConfigurationScriptLoader {
    private static final String DEFAULT_CONFIG_PROPERTY_KEY = "spock.configuration";
    private static final String DEFAULT_CLASS_PATH_LOCATION = "SpockConfig.groovy";
    private static final String DEFAULT_FILE_SYSTEM_LOCATION = System.getProperty("user.home") + File.separator + ".spock" + File.separator + "SpockConfig.groovy";
    private final String configPropertyKey;
    private final String classPathLocation;
    private final String fileSystemLocation;

    public ConfigurationScriptLoader() {
        this(DEFAULT_CONFIG_PROPERTY_KEY, DEFAULT_CLASS_PATH_LOCATION, DEFAULT_FILE_SYSTEM_LOCATION);
    }

    ConfigurationScriptLoader(String configPropertyKey, String classPathLocation, String fileSystemLocation) {
        this.configPropertyKey = configPropertyKey;
        this.classPathLocation = classPathLocation;
        this.fileSystemLocation = fileSystemLocation;
    }

    public DelegatingScript loadAutoDetectedScript() {
        DelegatingScript script = this.loadScriptFromSystemPropertyInducedLocation(this.configPropertyKey);
        if (script != null) {
            return script;
        }
        script = this.loadScriptFromClassPathLocation(this.classPathLocation);
        if (script != null) {
            return script;
        }
        script = this.loadScriptFromFileSystemLocation(this.fileSystemLocation);
        if (script != null) {
            return script;
        }
        return null;
    }

    public DelegatingScript loadClosureBasedScript(final Closure closure) {
        return new DelegatingScript(){

            public Object run() {
                GroovyRuntimeUtil.invokeClosure(closure, new Object[0]);
                return null;
            }

            public void $setDelegate(Object delegate) {
                closure.setResolveStrategy(1);
                closure.setDelegate(delegate);
            }
        };
    }

    private DelegatingScript loadScriptFromSystemPropertyInducedLocation(String propertyKey) {
        String location = System.getProperty(propertyKey);
        if (location == null || location.length() == 0) {
            return null;
        }
        DelegatingScript script = this.loadScriptFromClassPathLocation(location);
        if (script != null) {
            return script;
        }
        script = this.loadScriptFromFileSystemLocation(location);
        if (script != null) {
            return script;
        }
        throw new ConfigurationException("Cannot find configuration script '%s'", location);
    }

    private DelegatingScript loadScriptFromFileSystemLocation(String location) {
        File file = new File(location);
        try {
            if (!file.exists()) {
                return null;
            }
        }
        catch (AccessControlException e) {
            return null;
        }
        GroovyShell shell = this.createShell();
        try {
            return (DelegatingScript)shell.parse(file);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading configuration script '%s'", location);
        }
        catch (CompilationFailedException e) {
            throw new ConfigurationException("Error compiling configuration script '%s'", location);
        }
    }

    private DelegatingScript loadScriptFromClassPathLocation(String location) {
        URL url = this.getClass().getClassLoader().getResource(location);
        if (url == null) {
            return null;
        }
        GroovyShell shell = this.createShell();
        try {
            return (DelegatingScript)shell.parse(new GroovyCodeSource(url));
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading configuration script '%s'", location);
        }
        catch (CompilationFailedException e) {
            throw new ConfigurationException("Error compiling configuration script '%s'", location);
        }
    }

    private GroovyShell createShell() {
        CompilerConfiguration compilerSettings = new CompilerConfiguration();
        compilerSettings.setScriptBaseClass(DelegatingScript.class.getName());
        return new GroovyShell(this.getClass().getClassLoader(), new Binding(), compilerSettings);
    }
}

