/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.typecheck;

import java.util.ArrayList;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IInferredTypeEnvironment;
import org.eventb.core.ast.ISealedTypeEnvironment;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.typecheck.TypeEnvironmentBuilder;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class InferredTypeEnvironment
extends TypeEnvironmentBuilder
implements IInferredTypeEnvironment {
    private final ISealedTypeEnvironment initialTypeEnvironment;

    public InferredTypeEnvironment(ITypeEnvironment initialTypeEnvironment) {
        super(initialTypeEnvironment.getFormulaFactory());
        this.initialTypeEnvironment = initialTypeEnvironment.makeSnapshot();
    }

    @Override
    public ISealedTypeEnvironment getInitialTypeEnvironment() {
        return this.initialTypeEnvironment;
    }

    @Override
    protected Type internalGetType(String name) {
        Type type = this.getType(name);
        if (type != null) {
            return type;
        }
        return this.initialTypeEnvironment.getType(name);
    }

    public void solveVariables(TypeUnifier unifier) {
        ArrayList<String> names = new ArrayList<String>(this.getNames());
        for (String name : names) {
            this.setName(name, unifier.solve(this.getType(name)));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        InferredTypeEnvironment other = (InferredTypeEnvironment)obj;
        return this.initialTypeEnvironment.equals(other.initialTypeEnvironment) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 17 * this.initialTypeEnvironment.hashCode();
    }

    @Override
    public final boolean isTranslatable(FormulaFactory fac) {
        return false;
    }

    @Override
    public IInferredTypeEnvironment translate(FormulaFactory fac) {
        throw new UnsupportedOperationException("An IInferredTypeEnvironment cannot be translated.");
    }
}

