/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;
import org.eventb.internal.core.parser.operators.Matrix;
import org.eventb.internal.core.parser.operators.OperatorGroup;
import org.eventb.internal.core.parser.operators.OperatorGroupCompact;

public class OpGroupCompactor {
    private final OperatorGroup initGroup;
    private final int firstKind;
    private final ExternalViewUtils.Instantiator<Integer, Integer> kindInst;

    public OpGroupCompactor(OperatorGroup initGroup, int firstKind, ExternalViewUtils.Instantiator<Integer, Integer> kindInst) {
        this.initGroup = initGroup;
        this.firstKind = firstKind;
        this.kindInst = kindInst;
    }

    public OperatorGroupCompact compact() {
        Set<Integer> allOperators = this.initGroup.getAllOperators();
        int opCount = allOperators.size();
        int lastKind = this.firstKind + opCount - 1;
        ArrayList<Integer> ops = new ArrayList<Integer>(allOperators);
        Collections.sort(ops);
        for (int i = 0; i < ops.size(); ++i) {
            Integer initKind = (Integer)ops.get(i);
            Integer newKind = this.firstKind + i;
            this.kindInst.setInst(initKind, newKind);
        }
        Matrix compatibilityRelation = this.convert(this.initGroup.getCompatibilityRelation().getRelationMap(), opCount);
        Matrix operatorPriority = this.convert(this.initGroup.getOperatorPriority().getRelationMap(), opCount);
        BitSet associativeOperators = this.convert(this.initGroup.getAssociativeOperators(), opCount);
        BitSet spacedOperators = this.convert(this.initGroup.getSpacedOperators(), opCount);
        return new OperatorGroupCompact(this.initGroup.getId(), this.firstKind, lastKind, compatibilityRelation, operatorPriority, associativeOperators, spacedOperators);
    }

    private BitSet convert(Set<Integer> set, int opCount) {
        BitSet result = new BitSet(opCount);
        for (Integer i : set) {
            int local = this.localKind(i);
            result.set(local);
        }
        return result;
    }

    private Matrix convert(Map<Integer, Set<Integer>> relationMap, int opCount) {
        Matrix result = new Matrix(opCount, this.firstKind);
        for (Map.Entry<Integer, Set<Integer>> rel : relationMap.entrySet()) {
            int left = this.localKind(rel.getKey());
            for (Integer relRight : rel.getValue()) {
                int right = this.localKind(relRight);
                result.set(left, right);
            }
        }
        return result;
    }

    private int localKind(int initKind) {
        return this.kindInst.instantiate(initKind);
    }
}

