/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class UnaryExpression
extends Expression {
    protected final Expression child;
    private static final int FIRST_TAG = 751;
    private static final String KCARD_ID = "Cardinal";
    private static final String POW_ID = "Power Set";
    private static final String POW1_ID = "Powerset 1";
    private static final String KUNION_ID = "Unary Union";
    private static final String KINTER_ID = "Unary Intersection";
    private static final String KDOM_ID = "Domain";
    private static final String KRAN_ID = "Range";
    private static final String KPRJ1_ID = "Old Projection 1";
    private static final String KPRJ2_ID = "Old Projection 2";
    private static final String KID_ID = "Old Identity";
    private static final String KMIN_ID = "Min";
    private static final String KMAX_ID = "Max";
    public static final String CONVERSE_ID = "Converse";
    private static final IOperatorInfo<Expression> OP_MINUS = new IOperatorInfo<Expression>(){

        @Override
        public IParserPrinter<Expression> makeParser(int kind) {
            return new SubParsers.UnminusParser(kind);
        }

        @Override
        public String getImage() {
            return "\u2212";
        }

        @Override
        public String getId() {
            return "Minus";
        }

        @Override
        public String getGroupId() {
            return StandardGroup.ARITHMETIC.getId();
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    };
    public static final int TAGS_LENGTH = Operators.values().length + 1;

    private static void initCommon(BMath grammar) {
        try {
            grammar.addOperator(Operators.OP_KCARD);
            grammar.addOperator(Operators.OP_POW);
            grammar.addOperator(Operators.OP_POW1);
            grammar.addOperator(Operators.OP_KUNION);
            grammar.addOperator(Operators.OP_KINTER);
            grammar.addOperator(Operators.OP_KDOM);
            grammar.addOperator(Operators.OP_KRAN);
            grammar.addOperator(Operators.OP_KMIN);
            grammar.addOperator(Operators.OP_KMAX);
            grammar.addOperator(Operators.OP_CONVERSE);
            grammar.addOperator(OP_MINUS);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    public static void initV1(BMath grammar) {
        try {
            UnaryExpression.initCommon(grammar);
            grammar.addOperator(Operators.OP_KPRJ1);
            grammar.addOperator(Operators.OP_KPRJ2);
            grammar.addOperator(Operators.OP_KID);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    public static void initV2(BMath grammar) {
        UnaryExpression.initCommon(grammar);
    }

    protected UnaryExpression(Expression child, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, child.hashCode());
        this.child = child;
        FormulaChecks.ensureTagInRange(tag, 751, TAGS_LENGTH);
        this.ensureSameFactory(this.child);
        this.setPredicateVariableCache(this.child);
        this.synthesizeType(null);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        Type resultType;
        this.freeIdents = this.child.freeIdents;
        this.boundIdents = this.child.boundIdents;
        if (!this.child.isTypeChecked()) {
            return;
        }
        FormulaFactory ff = this.getFactory();
        Type childType = this.child.getType();
        switch (this.getTag()) {
            case 764: {
                if (childType instanceof IntegerType) {
                    resultType = ff.makeIntegerType();
                    break;
                }
                resultType = null;
                break;
            }
            case 763: {
                Type alpha = childType.getSource();
                Type beta = childType.getTarget();
                if (alpha != null) {
                    resultType = ff.makeRelationalType(beta, alpha);
                    break;
                }
                resultType = null;
                break;
            }
            case 751: {
                Type alpha = childType.getBaseType();
                if (alpha != null) {
                    resultType = ff.makeIntegerType();
                    break;
                }
                resultType = null;
                break;
            }
            case 752: 
            case 753: {
                Type alpha = childType.getBaseType();
                if (alpha != null) {
                    resultType = ff.makePowerSetType(childType);
                    break;
                }
                resultType = null;
                break;
            }
            case 754: 
            case 755: {
                Type baseType = childType.getBaseType();
                if (baseType != null && baseType.getBaseType() != null) {
                    resultType = baseType;
                    break;
                }
                resultType = null;
                break;
            }
            case 756: {
                Type alpha = childType.getSource();
                if (alpha != null) {
                    resultType = ff.makePowerSetType(alpha);
                    break;
                }
                resultType = null;
                break;
            }
            case 757: {
                Type beta = childType.getTarget();
                if (beta != null) {
                    resultType = ff.makePowerSetType(beta);
                    break;
                }
                resultType = null;
                break;
            }
            case 758: {
                Type alpha = childType.getSource();
                Type beta = childType.getTarget();
                if (alpha != null) {
                    resultType = ff.makeRelationalType(ff.makeProductType(alpha, beta), alpha);
                    break;
                }
                resultType = null;
                break;
            }
            case 759: {
                Type alpha = childType.getSource();
                Type beta = childType.getTarget();
                if (alpha != null) {
                    resultType = ff.makeRelationalType(ff.makeProductType(alpha, beta), beta);
                    break;
                }
                resultType = null;
                break;
            }
            case 760: {
                Type alpha = childType.getBaseType();
                if (alpha != null) {
                    resultType = ff.makeRelationalType(alpha, alpha);
                    break;
                }
                resultType = null;
                break;
            }
            case 761: 
            case 762: {
                Type alpha = childType.getBaseType();
                if (alpha instanceof IntegerType) {
                    resultType = alpha;
                    break;
                }
                resultType = null;
                break;
            }
            default: {
                assert (false);
                resultType = null;
            }
        }
        if (resultType == null) {
            return;
        }
        this.setFinalType(resultType, givenType);
    }

    public Expression getChild() {
        return this.child;
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        UnaryExpression other = (UnaryExpression)expr;
        return this.child.equals(other.child);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        Type resultType;
        this.child.typeCheck(result, quantifiedIdentifiers);
        switch (this.getTag()) {
            case 764: {
                resultType = result.makeIntegerType();
                result.unify(this.child.getType(), resultType, this);
                break;
            }
            case 763: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makeRelationalType(alpha, beta), this);
                resultType = result.makeRelationalType(beta, alpha);
                break;
            }
            case 751: {
                TypeVariable alpha = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makePowerSetType(alpha), this);
                resultType = result.makeIntegerType();
                break;
            }
            case 752: 
            case 753: {
                TypeVariable alpha = result.newFreshVariable(null);
                PowerSetType childPattern = result.makePowerSetType(alpha);
                result.unify(this.child.getType(), childPattern, this);
                resultType = result.makePowerSetType(childPattern);
                break;
            }
            case 754: 
            case 755: {
                TypeVariable alpha = result.newFreshVariable(null);
                resultType = result.makePowerSetType(alpha);
                result.unify(this.child.getType(), result.makePowerSetType(resultType), this);
                break;
            }
            case 756: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makeRelationalType(alpha, beta), this);
                resultType = result.makePowerSetType(alpha);
                break;
            }
            case 757: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makeRelationalType(alpha, beta), this);
                resultType = result.makePowerSetType(beta);
                break;
            }
            case 758: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makeRelationalType(alpha, beta), this);
                resultType = result.makeRelationalType(result.makeProductType(alpha, beta), alpha);
                break;
            }
            case 759: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makeRelationalType(alpha, beta), this);
                resultType = result.makeRelationalType(result.makeProductType(alpha, beta), beta);
                break;
            }
            case 760: {
                TypeVariable alpha = result.newFreshVariable(null);
                result.unify(this.child.getType(), result.makePowerSetType(alpha), this);
                resultType = result.makeRelationalType(alpha, alpha);
                break;
            }
            case 761: 
            case 762: {
                resultType = result.makeIntegerType();
                result.unify(this.child.getType(), result.makePowerSetType(resultType), this);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setTemporaryType(resultType, result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.child.solveType(unifier);
    }

    private String getOperatorImage() {
        if (this.getTag() == 764) {
            return OP_MINUS.getImage();
        }
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        assert (this.getTag() != 764);
        return Operators.values()[this.getTag() - 751];
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        int kind = mediator.getKind();
        if (this.getTag() == 764) {
            OP_MINUS.makeParser(kind).toString(mediator, this);
            return;
        }
        Operators operator = this.getOperator();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]" + this.getTypeName() + "\n" + this.child.getSyntaxTree(boundNames, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        this.child.isLegible(result);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.child.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        this.child.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 751: {
                goOn = visitor.enterKCARD(this);
                break;
            }
            case 752: {
                goOn = visitor.enterPOW(this);
                break;
            }
            case 753: {
                goOn = visitor.enterPOW1(this);
                break;
            }
            case 754: {
                goOn = visitor.enterKUNION(this);
                break;
            }
            case 755: {
                goOn = visitor.enterKINTER(this);
                break;
            }
            case 756: {
                goOn = visitor.enterKDOM(this);
                break;
            }
            case 757: {
                goOn = visitor.enterKRAN(this);
                break;
            }
            case 758: {
                goOn = visitor.enterKPRJ1(this);
                break;
            }
            case 759: {
                goOn = visitor.enterKPRJ2(this);
                break;
            }
            case 760: {
                goOn = visitor.enterKID(this);
                break;
            }
            case 761: {
                goOn = visitor.enterKMIN(this);
                break;
            }
            case 762: {
                goOn = visitor.enterKMAX(this);
                break;
            }
            case 763: {
                goOn = visitor.enterCONVERSE(this);
                break;
            }
            case 764: {
                goOn = visitor.enterUNMINUS(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (goOn) {
            goOn = this.child.accept(visitor);
        }
        switch (this.getTag()) {
            case 751: {
                return visitor.exitKCARD(this);
            }
            case 752: {
                return visitor.exitPOW(this);
            }
            case 753: {
                return visitor.exitPOW1(this);
            }
            case 754: {
                return visitor.exitKUNION(this);
            }
            case 755: {
                return visitor.exitKINTER(this);
            }
            case 756: {
                return visitor.exitKDOM(this);
            }
            case 757: {
                return visitor.exitKRAN(this);
            }
            case 758: {
                return visitor.exitKPRJ1(this);
            }
            case 759: {
                return visitor.exitKPRJ2(this);
            }
            case 760: {
                return visitor.exitKID(this);
            }
            case 761: {
                return visitor.exitKMIN(this);
            }
            case 762: {
                return visitor.exitKMAX(this);
            }
            case 763: {
                return visitor.exitCONVERSE(this);
            }
            case 764: {
                return visitor.exitUNMINUS(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        Expression newChild = (Expression)this.child.rewrite(rewriter);
        FormulaFactory ff = rewriter.getFactory();
        SourceLocation sloc = this.getSourceLocation();
        if (this.getTag() == 764 && newChild.getTag() == 4 && rewriter.autoFlatteningMode()) {
            BigInteger value = ((IntegerLiteral)newChild).getValue();
            IntegerLiteral before = ff.makeIntegerLiteral(value.negate(), sloc);
            return rewriter.rewrite(this, before);
        }
        boolean changed = newChild != this.child;
        return rewriter.rewrite(this, changed, newChild);
    }

    @Override
    public boolean isATypeExpression() {
        return this.getTag() == 752 && this.child.isATypeExpression();
    }

    @Override
    public Type toType() {
        if (this.getTag() != 752) {
            return super.toType();
        }
        Type childAsType = this.child.toType();
        return this.getFactory().makePowerSetType(childAsType);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        this.child.inspect(acc);
        acc.leaveChildren();
    }

    public Expression getChild(int index) {
        if (index == 0) {
            return this.child;
        }
        throw UnaryExpression.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        IPosition pos = this.child.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        if (index != 0) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Expression newChild = rewriter.rewrite(this.child);
        return this.getFactory().makeUnaryExpression(this.getTag(), newChild, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<UnaryExpression>
    {
        OP_KCARD("card", "Cardinal", StandardGroup.CLOSED, 751),
        OP_POW("\u2119", "Power Set", StandardGroup.CLOSED, 752),
        OP_POW1("\u21191", "Powerset 1", StandardGroup.CLOSED, 753),
        OP_KUNION("union", "Unary Union", StandardGroup.CLOSED, 754),
        OP_KINTER("inter", "Unary Intersection", StandardGroup.CLOSED, 755),
        OP_KDOM("dom", "Domain", StandardGroup.CLOSED, 756),
        OP_KRAN("ran", "Range", StandardGroup.CLOSED, 757),
        OP_KPRJ1("prj1", "Old Projection 1", StandardGroup.CLOSED, 758),
        OP_KPRJ2("prj2", "Old Projection 2", StandardGroup.CLOSED, 759),
        OP_KID("id", "Old Identity", StandardGroup.CLOSED, 760),
        OP_KMIN("min", "Min", StandardGroup.CLOSED, 761),
        OP_KMAX("max", "Max", StandardGroup.CLOSED, 762),
        OP_CONVERSE("\u223c", "Converse", StandardGroup.UNARY_RELATION, 763){

            @Override
            public IParserPrinter<UnaryExpression> makeParser(int kind) {
                return new SubParsers.ConverseParser(kind);
            }
        };

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<UnaryExpression> makeParser(int kind) {
            return new SubParsers.UnaryExpressionParser(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

