/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.classicalb.core.preparser.lexer;

import java.io.*;
import java.util.*;
import de.be4.classicalb.core.preparser.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NO_DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 4: state = State.NO_DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITION_FILE; break;
                                case 3: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.DEFINITION_FILE; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TComment(text, line, pos); }
    Token new1(  String text,   int line,   int pos) { return new TCommentEnd(text, line, pos); }
    Token new2(  String text,   int line,   int pos) { return new TCommentContent(text, line, pos); }
    Token new3(  String text,   int line,   int pos) { return new TLineComment(text, line, pos); }
    Token new4(  int line,   int pos) { return new TDefinitions(line, pos); }
    Token new5(  String text,   int line,   int pos) { return new TOtherClauseBegin(text, line, pos); }
    Token new6(  String text,   int line,   int pos) { return new TEndMachine(text, line, pos); }
    Token new7(  int line,   int pos) { return new TKwDefinitions(line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TKwPrefix(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TNoDefSomething(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TIdentifierLiteral(text, line, pos); }
    Token new11(  int line,   int pos) { return new TLeftPar(line, pos); }
    Token new12(  int line,   int pos) { return new TRightPar(line, pos); }
    Token new13(  int line,   int pos) { return new TComma(line, pos); }
    Token new14(  int line,   int pos) { return new TBeginDefBody(line, pos); }
    Token new15(  String text,   int line,   int pos) { return new TRhsBody(text, line, pos); }
    Token new16(  String text,   int line,   int pos) { return new TBeginNesting(text, line, pos); }
    Token new17(  String text,   int line,   int pos) { return new TEndNesting(text, line, pos); }
    Token new18(  String text,   int line,   int pos) { return new TRhsIdentifier(text, line, pos); }
    Token new19(  String text,   int line,   int pos) { return new TSemicolon(text, line, pos); }
    Token new20(  String text,   int line,   int pos) { return new TDoubleQuotation(text, line, pos); }
    Token new21(  String text,   int line,   int pos) { return new TFilename(text, line, pos); }
    Token new22(  String text,   int line,   int pos) { return new TSomething(text, line, pos); }
    Token new23(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 35, 4}, {36, 46, 2}, {47, 47, 5}, {48, 64, 2}, {65, 65, 6}, {66, 66, 2}, {67, 67, 7}, {68, 68, 8}, {69, 69, 9}, {70, 72, 2}, {73, 73, 10}, {74, 75, 2}, {76, 76, 11}, {77, 77, 12}, {78, 78, 2}, {79, 79, 13}, {80, 80, 14}, {81, 81, 2}, {82, 82, 15}, {83, 83, 16}, {84, 84, 2}, {85, 85, 17}, {86, 86, 18}, {87, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 19}, {127, 160, 19}, {8206, 8207, 19}, {8232, 8233, 19}, },
            {},
            {{0, 33, 20}, {34, 34, 21}, {35, 65535, 20}, },
            {{65, 65, 22}, {67, 67, 23}, {68, 68, 24}, {69, 69, 25}, {73, 73, 26}, {76, 76, 27}, {79, 79, 28}, {80, 80, 29}, {82, 82, 30}, {83, 83, 31}, {85, 85, 32}, {86, 86, 33}, },
            {{42, 42, 34}, {47, 47, 35}, },
            {{66, 66, 36}, {83, 83, 37}, },
            {{79, 79, 38}, },
            {{69, 69, 39}, },
            {{78, 78, 40}, {86, 86, 41}, {88, 88, 42}, },
            {{77, 77, 43}, {78, 78, 44}, },
            {{79, 79, 45}, },
            {{65, 65, 46}, {79, 79, 47}, },
            {{80, 80, 48}, },
            {{82, 82, 49}, },
            {{69, 69, 50}, },
            {{69, 69, 51}, {89, 89, 52}, },
            {{83, 83, 53}, },
            {{65, 65, 54}, },
            {{0, 8233, -3}, },
            {{0, 65535, -5}, },
            {},
            {{66, 66, 55}, {83, 83, 56}, },
            {{79, 79, 57}, },
            {{69, 69, 58}, },
            {{86, 86, 59}, {88, 88, 60}, },
            {{77, 77, 61}, {78, 78, 62}, },
            {{79, 79, 63}, },
            {{80, 80, 64}, },
            {{82, 82, 65}, },
            {{69, 69, 66}, },
            {{69, 69, 67}, {85, 85, 68}, },
            {{83, 83, 69}, },
            {{65, 65, 70}, },
            {},
            {{0, 9, 71}, {10, 10, 72}, {11, 12, 71}, {13, 13, 72}, {14, 65535, 71}, },
            {{83, 83, 73}, },
            {{83, 83, 74}, },
            {{78, 78, 75}, },
            {{70, 70, 76}, },
            {{68, 68, 77}, },
            {{69, 69, 78}, },
            {{84, 84, 79}, },
            {{80, 80, 80}, },
            {{67, 67, 81}, {73, 73, 82}, {86, 86, 83}, },
            {{67, 67, 84}, },
            {{67, 67, 85}, },
            {{68, 68, 86}, },
            {{69, 69, 87}, },
            {{79, 79, 88}, },
            {{70, 70, 89}, },
            {{69, 69, 90}, {84, 84, 91}, },
            {{83, 83, 92}, },
            {{69, 69, 93}, },
            {{76, 76, 94}, {82, 82, 95}, },
            {{83, 83, 96}, },
            {{83, 83, 97}, },
            {{78, 78, 98}, },
            {{70, 70, 99}, },
            {{69, 69, 100}, },
            {{80, 80, 101}, },
            {{80, 80, 102}, },
            {{67, 67, 103}, {73, 73, 104}, {86, 86, 105}, },
            {{67, 67, 106}, },
            {{69, 69, 107}, },
            {{69, 69, 108}, {79, 79, 109}, },
            {{70, 70, 110}, },
            {{69, 69, 111}, {84, 84, 112}, },
            {{66, 66, 113}, },
            {{69, 69, 114}, },
            {{76, 76, 115}, {82, 82, 116}, },
            {{0, 65535, -37}, },
            {},
            {{84, 84, 117}, },
            {{69, 69, 118}, },
            {{67, 67, 119}, {83, 83, 120}, },
            {{73, 73, 121}, },
            {},
            {{78, 78, 122}, },
            {{69, 69, 123}, },
            {{76, 76, 124}, {79, 79, 125}, },
            {{76, 76, 126}, },
            {{84, 84, 127}, },
            {{65, 65, 128}, },
            {{65, 65, 129}, },
            {{72, 72, 130}, },
            {{69, 69, 131}, },
            {{82, 82, 132}, },
            {{77, 77, 133}, {80, 80, 134}, },
            {{73, 73, 135}, },
            {{83, 83, 136}, },
            {{83, 83, 137}, },
            {{84, 84, 138}, },
            {{83, 83, 139}, },
            {{85, 85, 140}, },
            {{73, 73, 141}, },
            {{84, 84, 142}, },
            {{69, 69, 143}, },
            {{67, 67, 144}, {83, 83, 145}, },
            {{73, 73, 146}, },
            {{78, 78, 147}, },
            {{82, 82, 148}, },
            {{76, 76, 149}, {79, 79, 150}, },
            {{76, 76, 151}, },
            {{84, 84, 152}, },
            {{65, 65, 153}, },
            {{65, 65, 154}, },
            {{82, 82, 155}, },
            {{68, 68, 156}, },
            {{77, 77, 157}, {80, 80, 158}, },
            {{73, 73, 159}, },
            {{83, 83, 160}, },
            {{83, 83, 161}, },
            {{83, 83, 162}, },
            {{83, 83, 163}, },
            {{85, 85, 164}, },
            {{73, 73, 165}, },
            {{82, 82, 166}, },
            {{82, 82, 167}, },
            {{82, 82, 168}, },
            {{84, 84, 169}, },
            {{78, 78, 170}, },
            {{84, 84, 171}, },
            {{78, 78, 172}, },
            {{69, 69, 173}, },
            {{82, 82, 174}, },
            {{85, 85, 175}, },
            {{73, 73, 176}, },
            {{82, 82, 177}, },
            {{76, 76, 178}, },
            {{73, 73, 179}, },
            {{76, 76, 180}, },
            {{65, 65, 181}, },
            {{79, 79, 182}, },
            {{69, 69, 183}, },
            {{78, 78, 184}, },
            {},
            {},
            {{69, 69, 185}, },
            {},
            {{69, 69, 186}, },
            {{65, 65, 187}, },
            {{82, 82, 188}, },
            {{82, 82, 189}, },
            {{82, 82, 190}, },
            {{84, 84, 191}, },
            {{78, 78, 192}, },
            {{84, 84, 193}, },
            {{69, 69, 194}, },
            {{69, 69, 195}, },
            {{82, 82, 196}, },
            {{85, 85, 197}, },
            {{73, 73, 198}, },
            {{82, 82, 199}, },
            {{76, 76, 200}, },
            {{65, 65, 201}, },
            {{73, 73, 202}, },
            {{79, 79, 203}, },
            {{69, 69, 204}, },
            {{78, 78, 205}, },
            {},
            {},
            {{84, 84, 206}, },
            {},
            {{69, 69, 207}, },
            {{65, 65, 208}, },
            {{65, 65, 209}, },
            {{84, 84, 210}, },
            {{69, 69, 211}, },
            {{65, 65, 212}, {82, 82, 213}, },
            {{73, 73, 214}, },
            {{83, 83, 215}, },
            {{68, 68, 216}, },
            {{77, 77, 217}, },
            {{84, 84, 218}, },
            {{68, 68, 219}, },
            {{65, 65, 220}, },
            {{73, 73, 221}, },
            {{95, 95, 222}, },
            {{78, 78, 223}, },
            {},
            {{84, 84, 224}, },
            {{84, 84, 225}, },
            {{82, 82, 226}, },
            {{69, 69, 227}, },
            {{77, 77, 228}, },
            {{83, 83, 229}, },
            {{66, 66, 230}, },
            {{65, 65, 231}, },
            {{84, 84, 232}, },
            {{69, 69, 233}, },
            {{65, 65, 234}, {82, 82, 235}, },
            {{73, 73, 236}, },
            {{83, 83, 237}, },
            {{83, 83, 238}, },
            {{77, 77, 239}, },
            {{84, 84, 240}, },
            {{68, 68, 241}, },
            {{65, 65, 242}, },
            {{73, 73, 243}, },
            {{95, 95, 244}, },
            {{84, 84, 245}, },
            {{67, 67, 246}, },
            {{84, 84, 247}, },
            {{82, 82, 248}, },
            {{69, 69, 249}, },
            {{73, 73, 250}, },
            {{83, 83, 251}, },
            {{66, 66, 252}, },
            {{67, 67, 253}, },
            {{73, 73, 254}, },
            {{84, 84, 255}, },
            {{78, 78, 256}, },
            {{65, 65, 257}, },
            {{84, 84, 258}, },
            {},
            {{83, 83, 259}, },
            {{69, 69, 260}, },
            {{83, 83, 261}, },
            {{69, 69, 262}, },
            {{76, 76, 263}, },
            {{65, 65, 264}, },
            {{79, 79, 265}, },
            {{69, 69, 266}, },
            {{73, 73, 267}, },
            {{69, 69, 268}, },
            {{84, 84, 269}, },
            {{77, 77, 270}, {83, 83, 271}, },
            {},
            {},
            {{76, 76, 272}, },
            {{67, 67, 273}, },
            {{73, 73, 274}, },
            {{84, 84, 275}, },
            {{78, 78, 276}, },
            {{65, 65, 277}, },
            {{84, 84, 278}, },
            {},
            {{83, 83, 279}, },
            {{69, 69, 280}, },
            {{83, 83, 281}, },
            {{69, 69, 282}, },
            {{76, 76, 283}, },
            {{65, 65, 284}, },
            {{79, 79, 285}, },
            {{73, 73, 286}, },
            {{65, 65, 287}, },
            {{69, 69, 288}, },
            {{84, 84, 289}, },
            {{83, 83, 290}, },
            {{84, 84, 291}, },
            {},
            {{76, 76, 292}, },
            {{84, 84, 293}, },
            {{79, 79, 294}, },
            {{69, 69, 295}, },
            {{84, 84, 296}, },
            {{73, 73, 297}, },
            {{73, 73, 298}, },
            {},
            {{78, 78, 299}, },
            {},
            {{83, 83, 300}, },
            {{73, 73, 301}, },
            {{78, 78, 302}, },
            {{80, 80, 303}, },
            {},
            {{79, 79, 304}, },
            {{83, 83, 305}, },
            {{73, 73, 306}, },
            {{69, 69, 307}, },
            {},
            {{69, 69, 308}, },
            {{84, 84, 309}, },
            {{79, 79, 310}, },
            {{69, 69, 311}, },
            {{84, 84, 312}, },
            {{73, 73, 313}, },
            {{73, 73, 314}, },
            {{73, 73, 315}, },
            {{78, 78, 316}, },
            {},
            {{83, 83, 317}, },
            {{73, 73, 318}, },
            {{78, 78, 319}, },
            {{80, 80, 320}, },
            {{79, 79, 321}, },
            {{84, 84, 322}, },
            {{83, 83, 323}, },
            {{73, 73, 324}, },
            {},
            {{85, 85, 325}, },
            {{69, 69, 326}, },
            {{95, 95, 327}, },
            {{78, 78, 328}, },
            {{95, 95, 329}, },
            {{83, 83, 330}, },
            {{78, 78, 331}, },
            {{79, 79, 332}, },
            {{84, 84, 333}, },
            {},
            {{83, 83, 334}, {90, 90, 335}, },
            {{84, 84, 336}, },
            {{69, 69, 337}, },
            {{78, 78, 338}, },
            {},
            {{69, 69, 339}, },
            {{78, 78, 340}, },
            {{83, 83, 341}, },
            {{95, 95, 342}, },
            {{78, 78, 343}, },
            {{95, 95, 344}, },
            {{83, 83, 345}, },
            {{78, 78, 346}, },
            {{79, 79, 347}, },
            {{79, 79, 348}, },
            {{84, 84, 349}, },
            {},
            {{83, 83, 350}, {90, 90, 351}, },
            {{84, 84, 352}, },
            {{69, 69, 353}, },
            {{78, 78, 354}, },
            {{69, 69, 355}, },
            {},
            {{69, 69, 356}, },
            {{84, 84, 357}, },
            {{83, 83, 358}, },
            {{67, 67, 359}, {86, 86, 360}, },
            {{83, 83, 361}, },
            {{67, 67, 362}, {86, 86, 363}, },
            {},
            {{84, 84, 364}, },
            {{78, 78, 365}, },
            {{65, 65, 366}, },
            {{65, 65, 367}, },
            {{65, 65, 368}, },
            {},
            {{82, 82, 369}, },
            {{83, 83, 370}, },
            {{83, 83, 371}, },
            {{84, 84, 372}, },
            {},
            {{67, 67, 373}, {86, 86, 374}, },
            {{83, 83, 375}, },
            {{67, 67, 376}, {86, 86, 377}, },
            {},
            {{84, 84, 378}, },
            {{78, 78, 379}, },
            {{78, 78, 380}, },
            {{65, 65, 381}, },
            {{65, 65, 382}, },
            {{65, 65, 383}, },
            {},
            {{82, 82, 384}, },
            {{83, 83, 385}, },
            {},
            {{83, 83, 386}, },
            {{73, 73, 387}, },
            {},
            {{79, 79, 388}, },
            {{65, 65, 389}, },
            {},
            {{79, 79, 390}, },
            {{65, 65, 391}, },
            {{83, 83, 392}, },
            {{83, 83, 393}, },
            {{84, 84, 394}, },
            {{84, 84, 395}, },
            {{84, 84, 396}, },
            {{65, 65, 397}, },
            {},
            {},
            {},
            {{79, 79, 398}, },
            {{65, 65, 399}, },
            {},
            {{79, 79, 400}, },
            {{65, 65, 401}, },
            {{83, 83, 402}, },
            {{83, 83, 403}, },
            {},
            {{84, 84, 404}, },
            {{84, 84, 405}, },
            {{84, 84, 406}, },
            {{65, 65, 407}, },
            {},
            {},
            {{79, 79, 408}, },
            {{78, 78, 409}, },
            {{82, 82, 410}, },
            {{78, 78, 411}, },
            {{82, 82, 412}, },
            {},
            {},
            {{73, 73, 413}, },
            {{73, 73, 414}, },
            {{73, 73, 415}, },
            {{84, 84, 416}, },
            {{78, 78, 417}, },
            {{82, 82, 418}, },
            {{78, 78, 419}, },
            {{82, 82, 420}, },
            {},
            {},
            {{73, 73, 421}, },
            {{73, 73, 422}, },
            {{73, 73, 423}, },
            {{84, 84, 424}, },
            {{78, 78, 425}, },
            {{83, 83, 426}, },
            {{73, 73, 427}, },
            {{83, 83, 428}, },
            {{73, 73, 429}, },
            {{79, 79, 430}, },
            {{79, 79, 431}, },
            {{79, 79, 432}, },
            {{73, 73, 433}, },
            {{83, 83, 434}, },
            {{73, 73, 435}, },
            {{83, 83, 436}, },
            {{73, 73, 437}, },
            {{79, 79, 438}, },
            {{79, 79, 439}, },
            {{79, 79, 440}, },
            {{73, 73, 441}, },
            {},
            {{84, 84, 442}, },
            {{65, 65, 443}, },
            {{84, 84, 444}, },
            {{65, 65, 445}, },
            {{78, 78, 446}, },
            {{78, 78, 447}, },
            {{78, 78, 448}, },
            {{79, 79, 449}, },
            {{84, 84, 450}, },
            {{65, 65, 451}, },
            {{84, 84, 452}, },
            {{65, 65, 453}, },
            {{78, 78, 454}, },
            {{78, 78, 455}, },
            {{78, 78, 456}, },
            {{79, 79, 457}, },
            {{65, 65, 458}, },
            {{66, 66, 459}, },
            {{65, 65, 460}, },
            {{66, 66, 461}, },
            {},
            {},
            {},
            {{78, 78, 462}, },
            {{65, 65, 463}, },
            {{66, 66, 464}, },
            {{65, 65, 465}, },
            {{66, 66, 466}, },
            {},
            {},
            {},
            {{78, 78, 467}, },
            {{78, 78, 468}, },
            {{76, 76, 469}, },
            {{78, 78, 470}, },
            {{76, 76, 471}, },
            {{83, 83, 472}, },
            {{78, 78, 473}, },
            {{76, 76, 474}, },
            {{78, 78, 475}, },
            {{76, 76, 476}, },
            {{83, 83, 477}, },
            {{84, 84, 478}, },
            {{69, 69, 479}, },
            {{84, 84, 480}, },
            {{69, 69, 481}, },
            {},
            {{84, 84, 482}, },
            {{69, 69, 483}, },
            {{84, 84, 484}, },
            {{69, 69, 485}, },
            {},
            {{83, 83, 486}, },
            {{83, 83, 487}, },
            {{83, 83, 488}, },
            {{83, 83, 489}, },
            {{83, 83, 490}, },
            {{83, 83, 491}, },
            {{83, 83, 492}, },
            {{83, 83, 493}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
        }
        { // DEFINITIONS
            {{0, 32, 1}, {34, 34, 2}, {40, 40, 3}, {41, 41, 4}, {44, 44, 5}, {47, 47, 6}, {59, 59, 7}, {61, 61, 8}, {65, 65, 9}, {66, 66, 10}, {67, 67, 11}, {68, 68, 10}, {69, 69, 12}, {70, 72, 10}, {73, 73, 13}, {74, 75, 10}, {76, 76, 14}, {77, 77, 15}, {78, 78, 10}, {79, 79, 16}, {80, 80, 17}, {81, 81, 10}, {82, 82, 18}, {83, 83, 19}, {84, 84, 10}, {85, 85, 20}, {86, 86, 21}, {87, 90, 10}, {97, 122, 22}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {{0, 32, 1}, {127, 8233, -2}, },
            {},
            {},
            {},
            {},
            {{42, 42, 23}, },
            {},
            {{61, 61, 24}, },
            {{48, 57, 25}, {65, 65, 26}, {66, 66, 27}, {67, 82, 26}, {83, 83, 28}, {84, 90, 26}, {95, 95, 29}, {97, 122, 30}, },
            {{48, 57, 25}, {65, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 78, 26}, {79, 79, 31}, {80, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 77, 26}, {78, 78, 32}, {79, 85, 26}, {86, 86, 33}, {87, 87, 26}, {88, 88, 34}, {89, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 76, 26}, {77, 77, 35}, {78, 78, 36}, {79, 90, 26}, {95, 122, -11}, },
            {{48, 78, -13}, {79, 79, 37}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 38}, {66, 78, 26}, {79, 79, 39}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 79, 26}, {80, 80, 40}, {81, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 81, 26}, {82, 82, 41}, {83, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 68, 26}, {69, 69, 42}, {70, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 43}, {70, 88, 26}, {89, 89, 44}, {90, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 82, 26}, {83, 83, 45}, {84, 122, -11}, },
            {{48, 57, 25}, {65, 65, 46}, {66, 90, 26}, {95, 122, -11}, },
            {{48, 122, -12}, },
            {},
            {},
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 47}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 48}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 49}, {79, 122, -15}, },
            {{48, 57, 25}, {65, 67, 26}, {68, 68, 50}, {69, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 51}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 83, 26}, {84, 84, 52}, {85, 90, 26}, {95, 122, -11}, },
            {{48, 79, -18}, {80, 80, 53}, {81, 122, -18}, },
            {{48, 57, 25}, {65, 66, 26}, {67, 67, 54}, {68, 72, 26}, {73, 73, 55}, {74, 85, 26}, {86, 86, 56}, {87, 90, 26}, {95, 122, -11}, },
            {{48, 66, -38}, {67, 67, 57}, {68, 90, 26}, {95, 122, -11}, },
            {{48, 66, -38}, {67, 67, 58}, {68, 122, -39}, },
            {{48, 67, -34}, {68, 68, 59}, {69, 122, -34}, },
            {{48, 68, -20}, {69, 69, 60}, {70, 122, -20}, },
            {{48, 78, -13}, {79, 79, 61}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 69, 26}, {70, 70, 62}, {71, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 63}, {70, 83, 26}, {84, 84, 64}, {85, 122, -36}, },
            {{48, 82, -22}, {83, 83, 65}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 66}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 75, 26}, {76, 76, 67}, {77, 81, 26}, {82, 82, 68}, {83, 122, -19}, },
            {{48, 83, -36}, {84, 84, 69}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 70}, {70, 122, -20}, },
            {{48, 66, -38}, {67, 67, 71}, {68, 82, 26}, {83, 83, 72}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 73}, {79, 122, -15}, },
            {{48, 68, -20}, {69, 69, 74}, {70, 122, -20}, },
            {{48, 75, -48}, {76, 76, 75}, {77, 78, 26}, {79, 79, 76}, {80, 122, -13}, },
            {{48, 75, -48}, {76, 76, 77}, {77, 90, 26}, {95, 122, -11}, },
            {{48, 83, -36}, {84, 84, 78}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 79}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 80}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 71, 26}, {72, 72, 81}, {73, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 82}, {70, 122, -20}, },
            {{48, 81, -19}, {82, 82, 83}, {83, 122, -19}, },
            {{48, 76, -15}, {77, 77, 84}, {78, 79, 26}, {80, 80, 85}, {81, 122, -18}, },
            {{48, 57, 25}, {65, 72, 26}, {73, 73, 86}, {74, 90, 26}, {95, 122, -11}, },
            {{48, 82, -22}, {83, 83, 87}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 88}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 89}, {85, 122, -36}, },
            {{48, 82, -22}, {83, 83, 90}, {84, 122, -11}, },
            {{48, 57, 25}, {65, 84, 26}, {85, 85, 91}, {86, 90, 26}, {95, 122, -11}, },
            {{48, 72, -64}, {73, 73, 92}, {74, 122, -64}, },
            {{48, 81, -19}, {82, 82, 93}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 94}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 95}, {83, 122, -19}, },
            {{48, 83, -36}, {84, 84, 96}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 97}, {85, 122, -36}, },
            {{48, 77, -14}, {78, 78, 98}, {79, 122, -15}, },
            {{48, 68, -20}, {69, 69, 99}, {70, 122, -20}, },
            {{48, 81, -19}, {82, 82, 100}, {83, 122, -19}, },
            {{48, 84, -69}, {85, 85, 101}, {86, 122, -69}, },
            {{48, 72, -64}, {73, 73, 102}, {74, 122, -64}, },
            {{48, 81, -19}, {82, 82, 103}, {83, 122, -19}, },
            {{48, 75, -48}, {76, 76, 104}, {77, 122, -56}, },
            {{48, 72, -64}, {73, 73, 105}, {74, 122, -64}, },
            {{48, 75, -48}, {76, 76, 106}, {77, 122, -56}, },
            {{48, 57, 25}, {65, 65, 107}, {66, 122, -23}, },
            {{48, 78, -13}, {79, 79, 108}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 109}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 110}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 111}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 112}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 65, 113}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 114}, {66, 122, -23}, },
            {{48, 83, -36}, {84, 84, 115}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 116}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 65, 117}, {66, 81, 26}, {82, 82, 118}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 119}, {84, 122, -11}, },
            {{48, 67, -34}, {68, 68, 120}, {69, 122, -34}, },
            {{48, 76, -15}, {77, 77, 121}, {78, 90, 26}, {95, 122, -11}, },
            {{48, 83, -36}, {84, 84, 122}, {85, 122, -36}, },
            {{48, 67, -34}, {68, 68, 123}, {69, 122, -34}, },
            {{48, 57, 25}, {65, 65, 124}, {66, 122, -23}, },
            {{48, 72, -64}, {73, 73, 125}, {74, 122, -64}, },
            {{48, 90, -12}, {95, 95, 126}, {97, 122, 30}, },
            {{48, 77, -14}, {78, 78, 127}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 83, -36}, {84, 84, 128}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 129}, {85, 122, -36}, },
            {{48, 81, -19}, {82, 82, 130}, {83, 122, -19}, },
            {{48, 68, -20}, {69, 69, 131}, {70, 122, -20}, },
            {{48, 76, -15}, {77, 77, 132}, {78, 122, -101}, },
            {{48, 82, -22}, {83, 83, 133}, {84, 122, -11}, },
            {{48, 65, -11}, {66, 66, 134}, {67, 90, 26}, {95, 122, -11}, },
            {{48, 66, -38}, {67, 67, 135}, {68, 122, -39}, },
            {{48, 72, -64}, {73, 73, 136}, {74, 122, -64}, },
            {{48, 83, -36}, {84, 84, 137}, {85, 122, -36}, },
            {{48, 77, -14}, {78, 78, 138}, {79, 122, -15}, },
            {{48, 57, 25}, {65, 65, 139}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 140}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 141}, {70, 122, -20}, },
            {{48, 82, -22}, {83, 83, 142}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 143}, {70, 122, -20}, },
            {{48, 75, -48}, {76, 76, 144}, {77, 122, -56}, },
            {{48, 57, 25}, {65, 65, 145}, {66, 122, -23}, },
            {{48, 78, -13}, {79, 79, 146}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 147}, {70, 122, -20}, },
            {{48, 72, -64}, {73, 73, 148}, {74, 122, -64}, },
            {{48, 68, -20}, {69, 69, 149}, {70, 122, -20}, },
            {{48, 83, -36}, {84, 84, 150}, {85, 122, -36}, },
            {{48, 76, -15}, {77, 77, 151}, {78, 82, 26}, {83, 83, 152}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 75, -48}, {76, 76, 153}, {77, 122, -56}, },
            {{48, 83, -36}, {84, 84, 154}, {85, 122, -36}, },
            {{48, 78, -13}, {79, 79, 155}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 156}, {70, 122, -20}, },
            {{48, 83, -36}, {84, 84, 157}, {85, 122, -36}, },
            {{48, 72, -64}, {73, 73, 158}, {74, 122, -64}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 159}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 160}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 161}, {74, 122, -64}, },
            {{48, 77, -14}, {78, 78, 162}, {79, 122, -15}, },
            {{48, 79, -18}, {80, 80, 163}, {81, 122, -18}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 164}, {80, 122, -13}, },
            {{48, 82, -22}, {83, 83, 165}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 166}, {74, 122, -64}, },
            {{48, 68, -20}, {69, 69, 167}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 168}, {70, 122, -20}, },
            {{48, 90, -12}, {95, 95, 169}, {97, 122, 30}, },
            {{48, 77, -14}, {78, 78, 170}, {79, 122, -15}, },
            {{48, 90, -12}, {95, 95, 171}, {97, 122, 30}, },
            {{48, 82, -22}, {83, 83, 172}, {84, 122, -11}, },
            {{48, 77, -14}, {78, 78, 173}, {79, 122, -15}, },
            {{48, 83, -36}, {84, 84, 174}, {85, 122, -36}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 175}, {84, 89, 26}, {90, 90, 176}, {95, 122, -11}, },
            {{48, 83, -36}, {84, 84, 177}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 178}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 179}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 180}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 181}, {79, 122, -15}, },
            {{48, 82, -22}, {83, 83, 182}, {84, 122, -11}, },
            {{48, 66, -38}, {67, 67, 183}, {68, 85, 26}, {86, 86, 184}, {87, 122, -38}, },
            {{48, 82, -22}, {83, 83, 185}, {84, 122, -11}, },
            {{48, 66, -38}, {67, 67, 186}, {68, 85, 26}, {86, 86, 187}, {87, 122, -38}, },
            {{48, 122, -12}, },
            {{48, 83, -36}, {84, 84, 188}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 189}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 190}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 191}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 81, -19}, {82, 82, 192}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 193}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 194}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 195}, {85, 122, -36}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 196}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 197}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 198}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 199}, {66, 122, -23}, },
            {{48, 82, -22}, {83, 83, 200}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 201}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 202}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 203}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 204}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 205}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 206}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 207}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 208}, {83, 122, -19}, },
            {{48, 122, -12}, },
            {{48, 72, -64}, {73, 73, 209}, {74, 122, -64}, },
            {{48, 72, -64}, {73, 73, 210}, {74, 122, -64}, },
            {{48, 72, -64}, {73, 73, 211}, {74, 122, -64}, },
            {{48, 83, -36}, {84, 84, 212}, {85, 122, -36}, },
            {{48, 82, -22}, {83, 83, 213}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 214}, {74, 122, -64}, },
            {{48, 82, -22}, {83, 83, 215}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 216}, {74, 122, -64}, },
            {{48, 78, -13}, {79, 79, 217}, {80, 122, -13}, },
            {{48, 78, -13}, {79, 79, 218}, {80, 122, -13}, },
            {{48, 78, -13}, {79, 79, 219}, {80, 122, -13}, },
            {{48, 72, -64}, {73, 73, 220}, {74, 122, -64}, },
            {{48, 83, -36}, {84, 84, 221}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 222}, {66, 122, -23}, },
            {{48, 83, -36}, {84, 84, 223}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 224}, {66, 122, -23}, },
            {{48, 77, -14}, {78, 78, 225}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 226}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 227}, {79, 122, -15}, },
            {{48, 78, -13}, {79, 79, 228}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 229}, {66, 122, -23}, },
            {{48, 65, -11}, {66, 66, 230}, {67, 122, -115}, },
            {{48, 57, 25}, {65, 65, 231}, {66, 122, -23}, },
            {{48, 65, -11}, {66, 66, 232}, {67, 122, -115}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 233}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 234}, {79, 122, -15}, },
            {{48, 75, -48}, {76, 76, 235}, {77, 122, -56}, },
            {{48, 77, -14}, {78, 78, 236}, {79, 122, -15}, },
            {{48, 75, -48}, {76, 76, 237}, {77, 122, -56}, },
            {{48, 82, -22}, {83, 83, 238}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 239}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 240}, {70, 122, -20}, },
            {{48, 83, -36}, {84, 84, 241}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 242}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 243}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 244}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 245}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 246}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
        }
        { // DEFINITIONS_RHS
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 39, 2}, {40, 40, 4}, {41, 41, 5}, {42, 46, 2}, {47, 47, 6}, {48, 58, 2}, {59, 59, 7}, {60, 64, 2}, {65, 65, 8}, {66, 66, 9}, {67, 67, 10}, {68, 68, 11}, {69, 69, 12}, {70, 72, 11}, {73, 73, 13}, {74, 75, 11}, {76, 76, 14}, {77, 77, 15}, {78, 78, 11}, {79, 79, 16}, {80, 80, 17}, {81, 81, 11}, {82, 82, 18}, {83, 83, 19}, {84, 84, 11}, {85, 85, 20}, {86, 86, 21}, {87, 87, 22}, {88, 90, 11}, {91, 96, 2}, {97, 122, 23}, {123, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 1}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {},
            {{0, 33, 24}, {34, 34, 25}, {35, 65535, 24}, },
            {},
            {},
            {{42, 42, 26}, },
            {},
            {{48, 57, 27}, {65, 65, 28}, {66, 66, 29}, {67, 77, 28}, {78, 78, 30}, {79, 82, 28}, {83, 83, 31}, {84, 90, 28}, {95, 95, 32}, {97, 122, 33}, },
            {{48, 57, 27}, {65, 68, 28}, {69, 69, 34}, {70, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 65, 35}, {66, 71, 28}, {72, 72, 36}, {73, 78, 28}, {79, 79, 37}, {80, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 77, 28}, {78, 78, 38}, {79, 85, 28}, {86, 86, 39}, {87, 87, 28}, {88, 88, 40}, {89, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 69, 28}, {70, 70, 41}, {71, 76, 28}, {77, 77, 42}, {78, 78, 43}, {79, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 44}, {70, 78, 28}, {79, 79, 45}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 46}, {66, 78, 28}, {79, 79, 47}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 79, 28}, {80, 80, 48}, {81, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 81, 28}, {82, 82, 49}, {83, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 50}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 51}, {70, 88, 28}, {89, 89, 52}, {90, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 82, 28}, {83, 83, 53}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 65, 54}, {66, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 71, 28}, {72, 72, 55}, {73, 90, 28}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{0, 65535, -5}, },
            {},
            {},
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 56}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 88, 28}, {89, 89, 57}, {90, 122, -21}, },
            {{48, 82, -22}, {83, 83, 58}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 57, 27}, {65, 70, 28}, {71, 71, 59}, {72, 90, 28}, {95, 122, -10}, },
            {{48, 82, -22}, {83, 83, 60}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 78, 28}, {79, 79, 61}, {80, 122, -12}, },
            {{48, 77, -14}, {78, 78, 62}, {79, 122, -15}, },
            {{48, 57, 27}, {65, 67, 28}, {68, 68, 63}, {69, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 64}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 83, 28}, {84, 84, 65}, {85, 90, 28}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 79, -18}, {80, 80, 66}, {81, 122, -18}, },
            {{48, 57, 27}, {65, 66, 28}, {67, 67, 67}, {68, 72, 28}, {73, 73, 68}, {74, 85, 28}, {86, 86, 69}, {87, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 70}, {85, 122, -42}, },
            {{48, 66, -45}, {67, 67, 71}, {68, 90, 28}, {95, 122, -10}, },
            {{48, 66, -45}, {67, 67, 72}, {68, 122, -47}, },
            {{48, 67, -40}, {68, 68, 73}, {69, 122, -40}, },
            {{48, 68, -11}, {69, 69, 74}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 75}, {70, 78, 28}, {79, 79, 76}, {80, 122, -12}, },
            {{48, 69, -15}, {70, 70, 77}, {71, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 78}, {70, 75, 28}, {76, 76, 79}, {77, 83, 28}, {84, 84, 80}, {85, 122, -42}, },
            {{48, 82, -22}, {83, 83, 81}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 82}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 75, 28}, {76, 76, 83}, {77, 81, 28}, {82, 82, 84}, {83, 122, -19}, },
            {{48, 57, 27}, {65, 72, 28}, {73, 73, 85}, {74, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 86}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 87}, {70, 122, -11}, },
            {{48, 72, -57}, {73, 73, 88}, {74, 122, -57}, },
            {{48, 68, -11}, {69, 69, 89}, {70, 122, -11}, },
            {{48, 72, -57}, {73, 73, 90}, {74, 122, -57}, },
            {{48, 66, -45}, {67, 67, 91}, {68, 82, 28}, {83, 83, 92}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 93}, {79, 122, -15}, },
            {{48, 68, -11}, {69, 69, 94}, {70, 122, -11}, },
            {{48, 75, -56}, {76, 76, 95}, {77, 78, 28}, {79, 79, 96}, {80, 122, -12}, },
            {{48, 75, -56}, {76, 76, 97}, {77, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 98}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 99}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 57, 27}, {65, 65, 100}, {66, 122, -23}, },
            {{48, 71, -24}, {72, 72, 101}, {73, 122, -24}, },
            {{48, 68, -11}, {69, 69, 102}, {70, 122, -11}, },
            {{48, 81, -19}, {82, 82, 103}, {83, 122, -19}, },
            {{48, 122, -13}, },
            {{48, 57, 27}, {65, 76, 28}, {77, 77, 104}, {78, 79, 28}, {80, 80, 105}, {81, 122, -18}, },
            {{48, 72, -57}, {73, 73, 106}, {74, 122, -57}, },
            {{48, 82, -22}, {83, 83, 107}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 108}, {70, 122, -11}, },
            {{48, 82, -22}, {83, 83, 109}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 110}, {85, 122, -42}, },
            {{48, 82, -22}, {83, 83, 111}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 84, 28}, {85, 85, 112}, {86, 90, 28}, {95, 122, -10}, },
            {{48, 72, -57}, {73, 73, 113}, {74, 122, -57}, },
            {{48, 75, -56}, {76, 76, 114}, {77, 122, -69}, },
            {{48, 81, -19}, {82, 82, 115}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 116}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 117}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 66, -45}, {67, 67, 118}, {68, 122, -47}, },
            {{48, 81, -19}, {82, 82, 119}, {83, 122, -19}, },
            {{48, 83, -42}, {84, 84, 120}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 121}, {85, 122, -42}, },
            {{48, 77, -14}, {78, 78, 122}, {79, 122, -15}, },
            {{48, 68, -11}, {69, 69, 123}, {70, 122, -11}, },
            {{48, 81, -19}, {82, 82, 124}, {83, 122, -19}, },
            {{48, 84, -85}, {85, 85, 125}, {86, 122, -85}, },
            {{48, 72, -57}, {73, 73, 126}, {74, 122, -57}, },
            {{48, 81, -19}, {82, 82, 127}, {83, 122, -19}, },
            {{48, 75, -56}, {76, 76, 128}, {77, 122, -69}, },
            {{48, 72, -57}, {73, 73, 129}, {74, 122, -57}, },
            {{48, 75, -56}, {76, 76, 130}, {77, 122, -69}, },
            {{48, 57, 27}, {65, 65, 131}, {66, 122, -23}, },
            {{48, 78, -38}, {79, 79, 132}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 133}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 134}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 66, -45}, {67, 67, 135}, {68, 122, -47}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 136}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 137}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 65, 138}, {66, 122, -23}, },
            {{48, 68, -11}, {69, 69, 139}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 65, 140}, {66, 122, -23}, },
            {{48, 83, -42}, {84, 84, 141}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 142}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 143}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 65, 144}, {66, 81, 28}, {82, 82, 145}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 146}, {84, 122, -10}, },
            {{48, 67, -40}, {68, 68, 147}, {69, 122, -40}, },
            {{48, 76, -78}, {77, 77, 148}, {78, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 149}, {85, 122, -42}, },
            {{48, 67, -40}, {68, 68, 150}, {69, 122, -40}, },
            {{48, 57, 27}, {65, 65, 151}, {66, 122, -23}, },
            {{48, 72, -57}, {73, 73, 152}, {74, 122, -57}, },
            {{48, 90, -13}, {95, 95, 153}, {97, 122, 33}, },
            {{48, 77, -14}, {78, 78, 154}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 83, -42}, {84, 84, 155}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 156}, {85, 122, -42}, },
            {{48, 81, -19}, {82, 82, 157}, {83, 122, -19}, },
            {{48, 68, -11}, {69, 69, 158}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 159}, {85, 122, -42}, },
            {{48, 76, -78}, {77, 77, 160}, {78, 122, -125}, },
            {{48, 82, -22}, {83, 83, 161}, {84, 122, -10}, },
            {{48, 65, -10}, {66, 66, 162}, {67, 90, 28}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 66, -45}, {67, 67, 163}, {68, 122, -47}, },
            {{48, 72, -57}, {73, 73, 164}, {74, 122, -57}, },
            {{48, 122, -13}, },
            {{48, 83, -42}, {84, 84, 165}, {85, 122, -42}, },
            {{48, 77, -14}, {78, 78, 166}, {79, 122, -15}, },
            {{48, 57, 27}, {65, 65, 167}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 168}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 169}, {70, 122, -11}, },
            {{48, 82, -22}, {83, 83, 170}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 171}, {70, 122, -11}, },
            {{48, 75, -56}, {76, 76, 172}, {77, 122, -69}, },
            {{48, 57, 27}, {65, 65, 173}, {66, 122, -23}, },
            {{48, 78, -38}, {79, 79, 174}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 175}, {70, 122, -11}, },
            {{48, 72, -57}, {73, 73, 176}, {74, 122, -57}, },
            {{48, 68, -11}, {69, 69, 177}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 178}, {85, 122, -42}, },
            {{48, 76, -78}, {77, 77, 179}, {78, 82, 28}, {83, 83, 180}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 75, -56}, {76, 76, 181}, {77, 122, -69}, },
            {{48, 83, -42}, {84, 84, 182}, {85, 122, -42}, },
            {{48, 78, -38}, {79, 79, 183}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 184}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 185}, {85, 122, -42}, },
            {{48, 72, -57}, {73, 73, 186}, {74, 122, -57}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 187}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 188}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 189}, {74, 122, -57}, },
            {{48, 77, -14}, {78, 78, 190}, {79, 122, -15}, },
            {{48, 79, -18}, {80, 80, 191}, {81, 122, -18}, },
            {{48, 122, -13}, },
            {{48, 78, -38}, {79, 79, 192}, {80, 122, -12}, },
            {{48, 82, -22}, {83, 83, 193}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 194}, {74, 122, -57}, },
            {{48, 68, -11}, {69, 69, 195}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 196}, {70, 122, -11}, },
            {{48, 90, -13}, {95, 95, 197}, {97, 122, 33}, },
            {{48, 77, -14}, {78, 78, 198}, {79, 122, -15}, },
            {{48, 90, -13}, {95, 95, 199}, {97, 122, 33}, },
            {{48, 82, -22}, {83, 83, 200}, {84, 122, -10}, },
            {{48, 77, -14}, {78, 78, 201}, {79, 122, -15}, },
            {{48, 83, -42}, {84, 84, 202}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 203}, {84, 89, 28}, {90, 90, 204}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 205}, {85, 122, -42}, },
            {{48, 68, -11}, {69, 69, 206}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 207}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 208}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 209}, {79, 122, -15}, },
            {{48, 82, -22}, {83, 83, 210}, {84, 122, -10}, },
            {{48, 66, -45}, {67, 67, 211}, {68, 85, 28}, {86, 86, 212}, {87, 122, -45}, },
            {{48, 82, -22}, {83, 83, 213}, {84, 122, -10}, },
            {{48, 66, -45}, {67, 67, 214}, {68, 85, 28}, {86, 86, 215}, {87, 122, -45}, },
            {{48, 122, -13}, },
            {{48, 83, -42}, {84, 84, 216}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 217}, {66, 122, -23}, },
            {{48, 57, 27}, {65, 65, 218}, {66, 122, -23}, },
            {{48, 57, 27}, {65, 65, 219}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 81, -19}, {82, 82, 220}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 221}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 222}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 223}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 78, -38}, {79, 79, 224}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 225}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 78, -38}, {79, 79, 226}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 227}, {66, 122, -23}, },
            {{48, 82, -22}, {83, 83, 228}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 229}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 230}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 231}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 232}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 233}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 234}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 235}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 236}, {83, 122, -19}, },
            {{48, 122, -13}, },
            {{48, 72, -57}, {73, 73, 237}, {74, 122, -57}, },
            {{48, 72, -57}, {73, 73, 238}, {74, 122, -57}, },
            {{48, 72, -57}, {73, 73, 239}, {74, 122, -57}, },
            {{48, 83, -42}, {84, 84, 240}, {85, 122, -42}, },
            {{48, 82, -22}, {83, 83, 241}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 242}, {74, 122, -57}, },
            {{48, 82, -22}, {83, 83, 243}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 244}, {74, 122, -57}, },
            {{48, 78, -38}, {79, 79, 245}, {80, 122, -12}, },
            {{48, 78, -38}, {79, 79, 246}, {80, 122, -12}, },
            {{48, 78, -38}, {79, 79, 247}, {80, 122, -12}, },
            {{48, 72, -57}, {73, 73, 248}, {74, 122, -57}, },
            {{48, 83, -42}, {84, 84, 249}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 250}, {66, 122, -23}, },
            {{48, 83, -42}, {84, 84, 251}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 252}, {66, 122, -23}, },
            {{48, 77, -14}, {78, 78, 253}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 254}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 255}, {79, 122, -15}, },
            {{48, 78, -38}, {79, 79, 256}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 257}, {66, 122, -23}, },
            {{48, 65, -10}, {66, 66, 258}, {67, 122, -140}, },
            {{48, 57, 27}, {65, 65, 259}, {66, 122, -23}, },
            {{48, 65, -10}, {66, 66, 260}, {67, 122, -140}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 261}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 262}, {79, 122, -15}, },
            {{48, 75, -56}, {76, 76, 263}, {77, 122, -69}, },
            {{48, 77, -14}, {78, 78, 264}, {79, 122, -15}, },
            {{48, 75, -56}, {76, 76, 265}, {77, 122, -69}, },
            {{48, 82, -22}, {83, 83, 266}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 267}, {85, 122, -42}, },
            {{48, 68, -11}, {69, 69, 268}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 269}, {85, 122, -42}, },
            {{48, 68, -11}, {69, 69, 270}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 271}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 272}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 273}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 274}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
        }
        { // DEFINITION_FILE
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 33, -2}, {35, 65535, -2}, },
            {{0, 33, 2}, {35, 65535, 2}, },
            {},
        }
        { // NO_DEFINITIONS
            {{0, 32, 1}, {33, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 65535, -2}, },
            {{0, 65535, 2}, },
        }
        { // COMMENT
            {{0, 32, 1}, {33, 41, 2}, {42, 42, 3}, {43, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 4}, {127, 160, 4}, {8206, 8207, 4}, {8232, 8233, 4}, },
            {},
            {{47, 47, 5}, },
            {{0, 8233, -3}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, -1, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, 8, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, 5, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, 5, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, 8, -1, -1, 8, -1, -1, 8, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, -1, -1, 8, -1, -1, -1, -1, 8, -1, -1, -1, -1, 8, 8, -1, -1, -1, -1, -1, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, 8, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, -1, -1, -1, -1, -1, 8, 8, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, 5, 8, 8, 8, 8, },
        // DEFINITIONS
        {-1, 23, 20, 11, 12, 13, -1, 19, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 0, 14, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 6, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 5, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 5, 10, 10, 10, 10, 10, 10, 5, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 5, 5, 5, 10, 10, 10, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 5, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 5, 10, 10, 10, 10, 5, 5, 5, 5, },
        // DEFINITIONS_RHS
        {-1, 23, 15, 15, 11, 12, 15, 19, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, 15, 0, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 16, 18, 18, 18, 18, 18, 17, 18, 18, 18, 18, 18, 18, 16, 18, 18, 18, 18, 16, 18, 18, 18, 18, 18, 18, 18, 18, 16, 18, 18, 18, 18, 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 5, 18, 5, 18, 5, 18, 18, 18, 18, 18, 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 5, 18, 18, 18, 18, 18, 18, 18, 18, 16, 18, 16, 16, 18, 18, 18, 5, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 16, 5, 5, 18, 18, 18, 18, 18, 18, 5, 18, 5, 18, 18, 18, 18, 5, 18, 18, 18, 18, 5, 18, 18, 18, 18, 18, 18, 18, 5, 18, 18, 18, 18, 5, 18, 18, 18, 18, 18, 18, 5, 18, 18, 18, 18, 5, 18, 18, 18, 18, 5, 18, 18, 5, 18, 18, 18, 18, 18, 18, 18, 5, 5, 5, 18, 18, 18, 18, 5, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 5, 5, 5, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 5, 18, 18, 18, 18, 5, 5, 5, 5, },
        // DEFINITION_FILE
        {21, 21, 21, 20, },
        // NO_DEFINITIONS
        {9, 9, 9, },
        // COMMENT
        {-1, 2, 2, 2, 23, 1, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State DEFINITIONS = new State(1);
        public final static State DEFINITIONS_RHS = new State(2);
        public final static State DEFINITION_FILE = new State(3);
        public final static State NO_DEFINITIONS = new State(4);
        public final static State COMMENT = new State(5);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
