/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.io.PrintWriter;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.Action;
import tlc2.tool.Cancelable;
import tlc2.tool.EvalException;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateMutSource;
import tlc2.tool.Tool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.LiveCheck1;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.ObjLongTable;
import tlc2.util.RandomGenerator;
import tlc2.util.statistics.DummyBucketStatistics;
import util.FileUtil;
import util.FilenameToStream;

public class Simulator
implements Cancelable {
    public static boolean EXPERIMENTAL_LIVENESS_SIMULATION = Boolean.getBoolean(Simulator.class.getName() + ".experimentalLiveness");
    private final ILiveCheck liveCheck;
    private final Tool tool;
    private final Action[] actions;
    private final Action[] invariants;
    private final Action[] impliedActions;
    private final boolean checkDeadlock;
    private final boolean checkLiveness;
    private long numOfGenStates;
    private final String traceFile;
    private final long traceDepth;
    private final long traceNum;
    private final RandomGenerator rng;
    private final long seed;
    private long aril;
    private final ObjLongTable astCounts;
    private boolean isCancelled;

    public Simulator(String specFile, String configFile, String traceFile, boolean deadlock, int traceDepth, long traceNum, RandomGenerator rng, long seed, boolean preprocess, FilenameToStream resolver) throws IOException {
        this(specFile, configFile, traceFile, deadlock, traceDepth, traceNum, rng, seed, preprocess, resolver, null);
    }

    public Simulator(String specFile, String configFile, String traceFile, boolean deadlock, int traceDepth, long traceNum, RandomGenerator rng, long seed, boolean preprocess, FilenameToStream resolver, SpecObj specObj) throws IOException {
        int lastSep = specFile.lastIndexOf(FileUtil.separatorChar);
        String specDir = lastSep == -1 ? "" : specFile.substring(0, lastSep + 1);
        specFile = specFile.substring(lastSep + 1);
        this.tool = new Tool(specDir, specFile, configFile, resolver);
        this.tool.init(preprocess, specObj);
        this.checkDeadlock = deadlock;
        this.checkLiveness = !this.tool.livenessIsTrue();
        this.actions = this.tool.getActions();
        this.invariants = this.tool.getInvariants();
        this.impliedActions = this.tool.getImpliedActions();
        this.numOfGenStates = 0L;
        this.traceDepth = traceDepth != -1 ? (long)traceDepth : Long.MAX_VALUE;
        this.traceFile = traceFile;
        this.traceNum = traceNum;
        this.rng = rng;
        this.seed = seed;
        this.aril = 0L;
        this.astCounts = new ObjLongTable(10);
        if (this.checkLiveness) {
            if (EXPERIMENTAL_LIVENESS_SIMULATION) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                this.liveCheck = new LiveCheck(this.tool, new Action[0], tmpDir, new DummyBucketStatistics());
            } else {
                this.liveCheck = new LiveCheck1(this.tool);
            }
        } else {
            this.liveCheck = new NoOpLiveCheck(this.tool, specDir);
        }
    }

    public void simulate() throws Exception {
        StateVec theInitStates = null;
        TLCState curState = null;
        if (this.isCancelled) {
            return;
        }
        try {
            theInitStates = this.tool.getInitStates();
            this.numOfGenStates = theInitStates.size();
            for (int i = 0; i < theInitStates.size(); ++i) {
                curState = theInitStates.elementAt(i);
                if (this.tool.isGoodState(curState)) {
                    for (int j = 0; j < this.invariants.length; ++j) {
                        if (this.tool.isValid(this.invariants[j], curState)) continue;
                        MP.printError(2107, new String[]{this.tool.getInvNames()[j], curState.toString()});
                        return;
                    }
                    continue;
                }
                MP.printError(2106, curState.toString());
                return;
            }
        }
        catch (Exception e) {
            if (curState != null) {
                MP.printError(2102, new String[]{e.getMessage() == null ? e.toString() : e.getMessage(), curState.toString()});
            } else {
                MP.printError(1000, e);
            }
            this.printSummary();
            return;
        }
        if (this.numOfGenStates == 0L) {
            MP.printError(2118);
            return;
        }
        theInitStates.deepNormalize();
        ProgressReport report = new ProgressReport();
        report.start();
        StateVec stateTrace = new StateVec((int)this.traceDepth);
        int idx = 0;
        try {
            int traceCnt = 1;
            while ((long)traceCnt <= this.traceNum) {
                this.aril = this.rng.getAril();
                stateTrace.clear();
                curState = this.randomState(theInitStates);
                boolean inConstraints = this.tool.isInModel(curState);
                int traceIdx = 0;
                while ((long)traceIdx < this.traceDepth) {
                    stateTrace.addElement(curState);
                    if (!inConstraints) break;
                    StateVec nextStates = this.randomNextStates(curState);
                    if (nextStates == null) {
                        if (!this.checkDeadlock) break;
                        this.printBehavior(2114, null, curState, stateTrace);
                        if (TLCGlobals.continuation) break;
                        return;
                    }
                    for (int i = 0; i < nextStates.size(); ++i) {
                        ++this.numOfGenStates;
                        TLCState state = nextStates.elementAt(i);
                        if (TLCGlobals.coverageInterval >= 0) {
                            ((TLCStateMutSource)state).addCounts(this.astCounts);
                        }
                        if (!this.tool.isGoodState(state)) {
                            this.printBehavior(2109, null, state, stateTrace);
                            return;
                        }
                        try {
                            for (idx = 0; idx < this.invariants.length; ++idx) {
                                if (this.tool.isValid(this.invariants[idx], state)) continue;
                                this.printBehavior(2110, new String[]{this.tool.getInvNames()[idx]}, state, stateTrace);
                                if (TLCGlobals.continuation) continue;
                                return;
                            }
                        }
                        catch (Exception e) {
                            this.printBehavior(2111, new String[]{this.tool.getInvNames()[idx], e.getMessage()}, state, stateTrace);
                            return;
                        }
                        try {
                            for (idx = 0; idx < this.impliedActions.length; ++idx) {
                                if (this.tool.isValid(this.impliedActions[idx], curState, state)) continue;
                                this.printBehavior(2112, new String[]{this.tool.getImpliedActNames()[idx]}, state, stateTrace);
                                if (TLCGlobals.continuation) continue;
                                return;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            this.printBehavior(2113, new String[]{this.tool.getImpliedActNames()[idx], e.getMessage()}, state, stateTrace);
                            return;
                        }
                    }
                    TLCState s1 = this.randomState(nextStates);
                    inConstraints = this.tool.isInModel(s1) && this.tool.isInActions(curState, s1);
                    curState = s1;
                    ++traceIdx;
                }
                this.liveCheck.checkTrace(stateTrace);
                if (this.traceFile != null) {
                    String fileName = this.traceFile + traceCnt;
                    PrintWriter pw = new PrintWriter(FileUtil.newBFOS(fileName));
                    pw.println("---------------- MODULE " + fileName + " -----------------");
                    for (idx = 0; idx < stateTrace.size(); ++idx) {
                        pw.println("STATE_" + (idx + 1) + " == ");
                        pw.println(stateTrace.elementAt(idx) + "\n");
                    }
                    pw.println("=================================================");
                    pw.close();
                }
                ++traceCnt;
            }
        }
        catch (Throwable e) {
            if (e instanceof LiveException) {
                this.printSummary();
            }
            this.printBehavior(1000, new String[]{MP.ECGeneralMsg("", e)}, curState, stateTrace);
        }
    }

    public final void printBehavior(int errorCode, String[] parameters, TLCState state, StateVec stateTrace) {
        MP.printError(errorCode, parameters);
        if (this.traceDepth == Long.MAX_VALUE) {
            MP.printMessage(2120);
            StatePrinter.printState(state);
        } else {
            MP.printError(2121);
            TLCState lastState = null;
            for (int i = 0; i < stateTrace.size(); ++i) {
                StatePrinter.printState(stateTrace.elementAt(i), lastState, i + 1);
                lastState = stateTrace.elementAt(i);
            }
            StatePrinter.printState(state, null, stateTrace.size() + 1);
        }
        this.printSummary();
    }

    public final TLCState randomState(StateVec states) throws EvalException {
        int len = states.size();
        if (len > 0) {
            int index = (int)Math.floor(this.rng.nextDouble() * (double)len);
            return states.elementAt(index);
        }
        return null;
    }

    @Override
    public void setCancelFlag(boolean flag) {
        this.isCancelled = flag;
    }

    public final StateVec randomNextStates(TLCState state) {
        int len = this.actions.length;
        int index = (int)Math.floor(this.rng.nextDouble() * (double)len);
        int p = this.rng.nextPrime();
        for (int i = 0; i < len; ++i) {
            StateVec pstates = this.tool.getNextStates(this.actions[index], state);
            if (!pstates.empty()) {
                return pstates;
            }
            index = (index + p) % len;
        }
        return null;
    }

    public final void printSummary() {
        this.reportCoverage();
        if (TLCGlobals.tool) {
            MP.printMessage(2209, String.valueOf(this.numOfGenStates));
        }
        MP.printMessage(2210, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.seed), String.valueOf(this.aril)});
    }

    public final void reportCoverage() {
        if (TLCGlobals.coverageInterval >= 0) {
            Object key;
            MP.printMessage(2201);
            ObjLongTable counts = this.tool.getPrimedLocs();
            ObjLongTable.Enumerator keys = this.astCounts.keys();
            while ((key = keys.nextElement()) != null) {
                String loc = ((SemanticNode)key).getLocation().toString();
                counts.add(loc, this.astCounts.get(key));
            }
            String[] skeys = counts.sortStringKeys();
            for (int i = 0; i < skeys.length; ++i) {
                long val = counts.get(skeys[i]);
                MP.printMessage(2221, new String[]{skeys[i].toString(), String.valueOf(val)});
            }
            MP.printMessage(2202);
        }
    }

    final class ProgressReport
    extends Thread {
        ProgressReport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count = TLCGlobals.coverageInterval / 60000;
            try {
                while (true) {
                    ProgressReport progressReport = this;
                    synchronized (progressReport) {
                        this.wait(60000L);
                    }
                    MP.printMessage(2209, String.valueOf(Simulator.this.numOfGenStates));
                    if (count > 1) {
                        --count;
                        continue;
                    }
                    Simulator.this.reportCoverage();
                    count = TLCGlobals.coverageInterval / 60000;
                }
            }
            catch (Exception e) {
                MP.printTLCBug(2124, null);
                return;
            }
        }
    }
}

