/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.Simulator;
import tlc2.util.RandomGenerator;
import util.ToolIO;

public class Generator {
    public static void main(String[] args) {
        System.out.println("TLC trace generator, " + TLCGlobals.versionOfTLC);
        String mainFile = null;
        String traceFile = null;
        boolean deadlock = true;
        String configFile = null;
        int traceDepth = 10;
        int traceNum = 10;
        boolean noSeed = true;
        long seed = 0L;
        long aril = 0L;
        int index = 0;
        while (index < args.length) {
            int len;
            if (args[index].equals("-f")) {
                if (++index >= args.length) {
                    Generator.printErrorMsg("Error: no argument given for -f option.");
                    return;
                }
                traceFile = args[index++];
                continue;
            }
            if (args[index].equals("-deadlock")) {
                ++index;
                deadlock = false;
                continue;
            }
            if (args[index].equals("-d")) {
                if (++index >= args.length) {
                    Generator.printErrorMsg("Error: no argument given for -d option.");
                    return;
                }
                traceDepth = Integer.parseInt(args[index]);
                ++index;
                continue;
            }
            if (args[index].equals("-n")) {
                if (++index >= args.length) {
                    Generator.printErrorMsg("Error: no argument given for -n option.");
                    return;
                }
                traceNum = Integer.parseInt(args[index]);
                ++index;
                continue;
            }
            if (args[index].equals("-coverage")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.coverageInterval = Integer.parseInt(args[index]) * 60 * 1000;
                        if (TLCGlobals.coverageInterval < 0) {
                            Generator.printErrorMsg("Error: expect a nonnegative integer for -coverage option.");
                            return;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        Generator.printErrorMsg("Error: An integer for coverage report interval required. But encountered " + args[index]);
                        return;
                    }
                }
                Generator.printErrorMsg("Error: coverage report interval required.");
                return;
            }
            if (args[index].equals("-s")) {
                if (++index < args.length) {
                    seed = Long.parseLong(args[index++]);
                    noSeed = false;
                    continue;
                }
                Generator.printErrorMsg("Error: seed required.");
                return;
            }
            if (args[index].equals("-aril")) {
                if (++index < args.length) {
                    aril = Long.parseLong(args[index++]);
                    continue;
                }
                Generator.printErrorMsg("Error: aril required.");
                return;
            }
            if (args[index].equals("-config")) {
                if (++index < args.length) {
                    configFile = args[index];
                    len = configFile.length();
                    if (configFile.startsWith(".cfg", len - 4)) {
                        configFile = configFile.substring(0, len - 4);
                    }
                    ++index;
                    continue;
                }
                Generator.printErrorMsg("Error: config file required.");
                return;
            }
            if (args[index].charAt(0) == '-') {
                Generator.printErrorMsg("Error: unrecognized option: " + args[index]);
                return;
            }
            if (mainFile != null) {
                Generator.printErrorMsg("Error: more than one input files: " + mainFile + " and " + args[index]);
                return;
            }
            len = mainFile.length();
            if (!(mainFile = args[index++]).startsWith(".tla", len - 4)) continue;
            mainFile = mainFile.substring(0, len - 4);
        }
        if (mainFile == null) {
            Generator.printErrorMsg("Error: Missing input TLA+ module.");
            return;
        }
        if (traceFile == null) {
            traceFile = mainFile + "_trace";
        }
        if (configFile == null) {
            configFile = mainFile;
        }
        try {
            RandomGenerator rng = new RandomGenerator();
            if (noSeed) {
                seed = rng.nextLong();
                rng.setSeed(seed);
            } else {
                rng.setSeed(seed, aril);
            }
            ToolIO.out.println("Generating random traces with seed " + seed + ".");
            Simulator simulator = new Simulator(mainFile, configFile, traceFile, deadlock, traceDepth, traceNum, rng, seed, true, null, null);
            simulator.simulate();
        }
        catch (Exception e) {
            MP.printError(1000, "generating traces", (Throwable)e);
        }
    }

    private static void printErrorMsg(String msg) {
        MP.printError(1101, msg);
    }
}

