/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.extension.IGrammar;
import org.eventb.core.ast.extension.IOperator;
import org.eventb.core.ast.extension.IOperatorGroup;
import org.eventb.internal.core.parser.operators.AllInOnceMap;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;
import org.eventb.internal.core.parser.operators.Matrix;
import org.eventb.internal.core.parser.operators.OperatorGroupCompact;
import org.eventb.internal.core.parser.operators.OperatorRelationship;

public class OperatorRegistryCompact {
    private final OperatorGroupCompact[] groups;
    private final int[] firstKinds;
    private final AllInOnceMap<String, Integer> idKind;
    private final Matrix groupPriority;

    public OperatorRegistryCompact(OperatorGroupCompact[] groups, int[] firstKinds, AllInOnceMap<String, Integer> idKind, Matrix groupPriority) {
        this.groups = groups;
        this.firstKinds = firstKinds;
        this.idKind = idKind;
        this.groupPriority = groupPriority;
    }

    private int getGroupIndex(int opKind) {
        for (int index = 0; index < this.firstKinds.length; ++index) {
            if (opKind >= this.firstKinds[index]) continue;
            return index - 1;
        }
        return -1;
    }

    private OperatorGroupCompact getGroup(int opKind) {
        int groupIndex = this.getGroupIndex(opKind);
        if (groupIndex < 0) {
            return null;
        }
        return this.groups[groupIndex];
    }

    public Map<Integer, String> getKindIds() {
        return this.idKind.invert();
    }

    public OperatorRelationship getOperatorRelationship(int leftKind, int rightKind) {
        int leftGroupIndex = this.getGroupIndex(leftKind);
        int rightGroupIndex = this.getGroupIndex(rightKind);
        if (leftGroupIndex == 0 && rightGroupIndex == 0) {
            return OperatorRelationship.LEFT_PRIORITY;
        }
        if (leftGroupIndex == 0) {
            return OperatorRelationship.RIGHT_PRIORITY;
        }
        if (rightGroupIndex == 0) {
            return OperatorRelationship.LEFT_PRIORITY;
        }
        if (this.groupPriority.get(leftGroupIndex, rightGroupIndex)) {
            return OperatorRelationship.RIGHT_PRIORITY;
        }
        if (this.groupPriority.get(rightGroupIndex, leftGroupIndex)) {
            return OperatorRelationship.LEFT_PRIORITY;
        }
        if (leftGroupIndex == rightGroupIndex) {
            OperatorGroupCompact group = this.groups[leftGroupIndex];
            if (group.hasLessPriority(leftKind, rightKind)) {
                return OperatorRelationship.RIGHT_PRIORITY;
            }
            if (group.hasLessPriority(rightKind, leftKind)) {
                return OperatorRelationship.LEFT_PRIORITY;
            }
            if (group.isCompatible(leftKind, rightKind)) {
                return OperatorRelationship.COMPATIBLE;
            }
            return OperatorRelationship.INCOMPATIBLE;
        }
        return OperatorRelationship.INCOMPATIBLE;
    }

    public boolean hasGroup(int kind) {
        return this.getGroupIndex(kind) > 0;
    }

    public boolean isAssociative(int kind) {
        OperatorGroupCompact group = this.getGroup(kind);
        return group.isAssociative(kind);
    }

    public boolean isSpaced(int kind) {
        OperatorGroupCompact group = this.getGroup(kind);
        return group.isSpaced(kind);
    }

    public boolean isDeclared(String operatorId) {
        return this.idKind.containsKey(operatorId);
    }

    public IGrammar asExternalView(ExternalViewUtils.Instantiator<Integer, IOperator> instantiator) {
        ExternalViewUtils.Instantiator<Integer, IOperatorGroup> groupInst = new ExternalViewUtils.Instantiator<Integer, IOperatorGroup>();
        HashSet<IOperatorGroup> extGroups = new HashSet<IOperatorGroup>();
        for (int i = 0; i < this.groups.length; ++i) {
            IOperatorGroup groupView = this.groups[i].asExternalView(instantiator);
            extGroups.add(groupView);
            groupInst.setInst(i, groupView);
        }
        Map<IOperatorGroup, Set<IOperatorGroup>> extGroupPrios = this.groupPriority.toRelationMap(groupInst);
        return new ExternalViewUtils.ExternalGrammar(extGroups, extGroupPrios);
    }
}

