/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

public class SourceLocation {
    private final int start;
    private final int end;
    private final Object origin;

    public SourceLocation(int start, int end) {
        this(start, end, null);
    }

    public SourceLocation(int start, int end, Object origin) {
        this.start = start;
        this.end = end;
        this.origin = origin;
    }

    public final boolean contains(SourceLocation other) {
        return this.start <= other.start && other.end <= this.end;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public int hashCode() {
        return 65536 * this.start + this.end;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SourceLocation) {
            SourceLocation other = (SourceLocation)obj;
            return this.start == other.start && this.end == other.end;
        }
        return false;
    }

    public String toString() {
        return this.start + ":" + this.end;
    }
}

