/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.DefaultTypeCheckingRewriter;
import org.eventb.internal.core.ast.Position;

class SingleRewriter {
    final IPosition position;
    final int[] indexes;
    int depth;
    final Formula<?> subFormula;

    public SingleRewriter(IPosition position, Formula<?> subFormula) {
        this.position = position;
        this.indexes = ((Position)position).indexes;
        this.depth = 0;
        this.subFormula = subFormula;
    }

    BoundIdentDecl getBoundIdentDecl(BoundIdentDecl src) {
        if (this.subFormula instanceof BoundIdentDecl) {
            return DefaultTypeCheckingRewriter.checkReplacement(src, (BoundIdentDecl)this.subFormula);
        }
        throw new IllegalArgumentException("New sub-formula should be a bound identifier declaration");
    }

    Expression getExpression(Expression src) {
        if (this.subFormula instanceof Expression) {
            return DefaultTypeCheckingRewriter.checkReplacement(src, (Expression)this.subFormula);
        }
        throw new IllegalArgumentException("New sub-formula should be an expression");
    }

    Predicate getPredicate(Predicate src) {
        if (this.subFormula instanceof Predicate) {
            return DefaultTypeCheckingRewriter.checkReplacement(src, (Predicate)this.subFormula);
        }
        throw new IllegalArgumentException("New sub-formula should be a predicate");
    }

    public <T extends Formula<T>> T rewrite(Formula<T> formula) {
        if (this.depth == this.indexes.length) {
            return formula.getCheckedReplacement(this);
        }
        int index = this.indexes[this.depth++];
        return formula.rewriteChild(index, this);
    }
}

