/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtensionKind;

public class ParametricType
extends Type {
    private static final Predicate[] NO_PRED = new Predicate[0];
    private final IExpressionExtension typeConstructor;
    private final Type[] typeParameters;

    private static boolean isSolved(Type[] typeParameters) {
        for (Type type : typeParameters) {
            if (type.isSolved()) continue;
            return false;
        }
        return true;
    }

    private static Expression[] buildExprs(Type[] typeParams, FormulaFactory factory) {
        int length = typeParams.length;
        Expression[] result = new Expression[length];
        for (int i = 0; i < length; ++i) {
            result[i] = typeParams[i].toExpression();
        }
        return result;
    }

    protected ParametricType(FormulaFactory ff, IExpressionExtension typeConstructor, Type[] typeParameters) {
        super(ff, ParametricType.isSolved(typeParameters));
        if (!typeConstructor.isATypeConstructor()) {
            throw new IllegalArgumentException("Invalid type constructor " + typeConstructor.getId());
        }
        this.typeConstructor = typeConstructor;
        this.typeParameters = typeParameters;
        this.ensureSameFactory(typeParameters);
        this.checkNumberOfParameters();
    }

    private void checkNumberOfParameters() {
        IExtensionKind kind = this.typeConstructor.getKind();
        if (!kind.checkTypePreconditions(this.typeParameters)) {
            throw new IllegalArgumentException("Wrong number of parameters for " + this.typeConstructor.getId());
        }
    }

    @Override
    protected void addGivenTypes(Set<GivenType> set) {
        for (Type type : this.typeParameters) {
            type.addGivenTypes(set);
        }
    }

    @Override
    protected Expression buildExpression(FormulaFactory factory) {
        return factory.makeExtendedExpression(this.typeConstructor, ParametricType.buildExprs(this.typeParameters, factory), NO_PRED, null, (Type)factory.makePowerSetType(this));
    }

    @Override
    protected void buildString(StringBuilder buffer) {
        buffer.append(this.typeConstructor.getSyntaxSymbol());
        if (this.typeParameters.length == 0) {
            return;
        }
        int sep = 40;
        for (Type param : this.typeParameters) {
            buffer.append((char)sep);
            sep = 44;
            param.buildString(buffer);
        }
        buffer.append(')');
    }

    public Type[] getTypeParameters() {
        return (Type[])this.typeParameters.clone();
    }

    public IExpressionExtension getExprExtension() {
        return this.typeConstructor;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParametricType other = (ParametricType)obj;
        return this.typeConstructor.equals(other.typeConstructor) && Arrays.equals(this.typeParameters, other.typeParameters);
    }

    @Override
    public int hashCode() {
        return Formula.combineHashCodes(this.typeConstructor.hashCode(), Formula.combineHashCodes(this.typeParameters));
    }

    @Override
    public void accept(ITypeVisitor visitor) {
        visitor.visit(this);
    }
}

