/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;

public class ASTProblem {
    private Object[] args;
    private SourceLocation location;
    private ProblemKind msg;
    private int severity;

    public ASTProblem(SourceLocation location, ProblemKind msg, int severity, Object ... args) {
        this.location = location;
        this.msg = msg;
        this.args = args;
        this.severity = severity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + this.msg.hashCode();
        result = 31 * result + this.severity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASTProblem other = (ASTProblem)obj;
        if (this.msg != other.msg || this.severity != other.severity) {
            return false;
        }
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public Object[] getArgs() {
        return this.args;
    }

    public ProblemKind getMessage() {
        return this.msg;
    }

    public int getSeverity() {
        return this.severity;
    }

    public SourceLocation getSourceLocation() {
        return this.location;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public String toString() {
        Object[] formatArgs;
        SourceLocation loc = this.getSourceLocation();
        if (loc != null) {
            formatArgs = new Object[this.args.length + 2];
            System.arraycopy(this.args, 0, formatArgs, 0, this.args.length);
            formatArgs[this.args.length] = loc.getStart();
            formatArgs[this.args.length + 1] = loc.getEnd();
        } else {
            formatArgs = this.args;
        }
        return String.format(this.getMessage().toString(), formatArgs);
    }
}

