/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.util.UnreachableCodeError;

public abstract class AbstractMethodInterceptor
implements IMethodInterceptor {
    public final void intercept(IMethodInvocation invocation) throws Throwable {
        switch (invocation.getMethod().getKind()) {
            case INITIALIZER: {
                this.interceptInitializerMethod(invocation);
                break;
            }
            case SHARED_INITIALIZER: {
                this.interceptSharedInitializerMethod(invocation);
                break;
            }
            case SETUP: {
                this.interceptSetupMethod(invocation);
                break;
            }
            case CLEANUP: {
                this.interceptCleanupMethod(invocation);
                break;
            }
            case SETUP_SPEC: {
                this.interceptSetupSpecMethod(invocation);
                break;
            }
            case CLEANUP_SPEC: {
                this.interceptCleanupSpecMethod(invocation);
                break;
            }
            case FEATURE: {
                this.interceptFeatureMethod(invocation);
                break;
            }
            case DATA_PROVIDER: {
                this.interceptDataProviderMethod(invocation);
                break;
            }
            case DATA_PROCESSOR: {
                this.interceptDataProcessorMethod(invocation);
                break;
            }
            case ITERATION_EXECUTION: {
                this.interceptIterationExecution(invocation);
                break;
            }
            case SPEC_EXECUTION: {
                this.interceptSpecExecution(invocation);
                break;
            }
            case FEATURE_EXECUTION: {
                this.interceptFeatureExecution(invocation);
                break;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptSharedInitializerMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptSetupMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptCleanupMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptSetupSpecMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptFeatureMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptDataProviderMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptDataProcessorMethod(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptIterationExecution(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptSpecExecution(IMethodInvocation invocation) throws Throwable {
    }

    public void interceptFeatureExecution(IMethodInvocation invocation) throws Throwable {
    }
}

