/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.IHashEq;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentList;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.Obj;
import com.github.krukow.clj_lang.PersistentVector;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.SeqIterator;
import com.github.krukow.clj_lang.Sequential;
import com.github.krukow.clj_lang.Util;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentQueue<T>
extends Obj
implements IPersistentList<T>,
Collection<T>,
Counted,
IHashEq {
    public static final PersistentQueue EMPTY = new PersistentQueue(null, 0, null, null);
    final int cnt;
    final ISeq f;
    final PersistentVector r;
    int _hash = -1;
    int _hasheq = -1;

    PersistentQueue(IPersistentMap meta, int cnt, ISeq f, PersistentVector r) {
        super(meta);
        this.cnt = cnt;
        this.f = f;
        this.r = r;
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq<T> s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equiv(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq<T> s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equals(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 1;
            for (ISeq<T> s = this.seq(); s != null; s = s.next()) {
                hash = 31 * hash + (s.first() == null ? 0 : s.first().hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            int hash = 1;
            for (ISeq<T> s = this.seq(); s != null; s = s.next()) {
                hash = 31 * hash + Util.hasheq(s.first());
            }
            this._hasheq = hash;
        }
        return this._hasheq;
    }

    @Override
    public T peek() {
        return (T)RT.first(this.f);
    }

    @Override
    public PersistentQueue<T> pop() {
        if (this.f == null) {
            return this;
        }
        ISeq f1 = this.f.next();
        PersistentVector r1 = this.r;
        if (f1 == null) {
            f1 = RT.seq(this.r);
            r1 = null;
        }
        return new PersistentQueue<T>(this.meta(), this.cnt - 1, f1, r1);
    }

    @Override
    public int count() {
        return this.cnt;
    }

    @Override
    public ISeq<T> seq() {
        if (this.f == null) {
            return null;
        }
        return new Seq(this.f, RT.seq(this.r));
    }

    @Override
    public PersistentQueue<T> cons(T o) {
        if (this.f == null) {
            return new PersistentQueue<T>(this.meta(), this.cnt + 1, RT.list(o), null);
        }
        return new PersistentQueue<T>(this.meta(), this.cnt + 1, this.f, (PersistentVector)(this.r != null ? this.r : PersistentVector.EMPTY).cons((Object)o));
    }

    @Override
    public IPersistentCollection<T> empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentQueue<T> withMeta(IPersistentMap meta) {
        return new PersistentQueue<T>(meta, this.cnt, this.f, this.r);
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq<T> s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new SeqIterator<T>(this.seq());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Seq<T>
    extends ASeq<T> {
        final ISeq<T> f;
        final ISeq<T> rseq;

        Seq(ISeq<T> f, ISeq<T> rseq) {
            this.f = f;
            this.rseq = rseq;
        }

        Seq(IPersistentMap meta, ISeq<T> f, ISeq<T> rseq) {
            super(meta);
            this.f = f;
            this.rseq = rseq;
        }

        @Override
        public T first() {
            return this.f.first();
        }

        @Override
        public ISeq<T> next() {
            ISeq<T> f1 = this.f.next();
            ISeq<T> r1 = this.rseq;
            if (f1 == null) {
                if (this.rseq == null) {
                    return null;
                }
                f1 = this.rseq;
                r1 = null;
            }
            return new Seq<T>(f1, r1);
        }

        @Override
        public int count() {
            return RT.count(this.f) + RT.count(this.rseq);
        }

        @Override
        public Seq<T> withMeta(IPersistentMap meta) {
            return new Seq<T>(meta, this.f, this.rseq);
        }
    }
}

