/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.model.eventb.EventBModel;
import de.prob.model.eventb.theory.Theory;
import de.prob.model.eventb.translate.TheoryExtractor;
import de.prob.model.representation.ModelElementList;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TheoryXmlHandler
extends DefaultHandler {
    Logger logger = LoggerFactory.getLogger(TheoryXmlHandler.class);
    private final String workspacePath;
    private final Set<IFormulaExtension> typeEnv = new HashSet<IFormulaExtension>();
    private EventBModel model;
    private ModelElementList<Theory> theories = new ModelElementList();
    private final HashMap<String, Theory> theoryMap = new HashMap();

    public TheoryXmlHandler(EventBModel model, String workspacePath) {
        this.model = model;
        this.workspacePath = workspacePath;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("org.eventb.theory.core.scAvailableTheory")) {
            String path = attributes.getValue("org.eventb.theory.core.availableTheory");
            if (!this.theoryMap.containsKey(path = path.substring(0, path.indexOf(124)))) {
                try {
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    SAXParser saxParser = parserFactory.newSAXParser();
                    String dir = path.substring(path.indexOf(47) + 1, path.lastIndexOf(47));
                    String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
                    TheoryExtractor extractor = new TheoryExtractor(this.workspacePath, dir, name, this.theoryMap);
                    saxParser.parse(new File(this.workspacePath + path), (DefaultHandler)extractor);
                    this.theories = this.theories.addMultiple(extractor.getTheories());
                    this.typeEnv.addAll(extractor.getTypeEnv());
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.theories = this.theories.addElement(this.theoryMap.get(path));
            }
        }
    }

    public Set<IFormulaExtension> getTypeEnv() {
        return this.typeEnv;
    }

    @Override
    public void endDocument() throws SAXException {
        this.model = this.model.set(Theory.class, this.theories);
    }

    public EventBModel getModel() {
        return this.model;
    }
}

