/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import com.google.common.base.MoreObjects;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProBConnection {
    private final int BUFFER_SIZE = 1024;
    private Socket socket;
    private BufferedInputStream inputStream;
    private PrintStream outputStream;
    private final Logger logger = LoggerFactory.getLogger(ProBConnection.class);
    private volatile boolean shutingDown;
    private volatile boolean busy;
    private final String key;
    private final int port;

    public ProBConnection(String key, int port) {
        this.key = key;
        this.port = port;
    }

    public String toString() {
        return MoreObjects.toStringHelper(ProBConnection.class).add("key", (Object)this.key).add("port", this.port).toString();
    }

    public void connect() throws IOException {
        this.logger.debug("Connecting to port {} using key {}", (Object)this.port, (Object)this.key);
        this.socket = new Socket(InetAddress.getByName(null), this.port);
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        OutputStream outstream = this.socket.getOutputStream();
        this.outputStream = new PrintStream(outstream, false, Charset.defaultCharset().name());
        this.logger.debug("Connected");
    }

    public String send(String term) throws IOException {
        this.logger.info(term);
        if (this.shutingDown) {
            String message = "probcli is currently shutting down";
            this.logger.error("probcli is currently shutting down");
            throw new IllegalStateException("ProB has been shut down. It does not accept messages. Received: " + term);
        }
        if (this.isStreamReady()) {
            this.outputStream.println(term);
            this.outputStream.flush();
        }
        String answer = this.getAnswer();
        this.logger.info(answer);
        return answer;
    }

    public boolean isBusy() {
        return this.busy;
    }

    private String getAnswer() throws IOException {
        String input = null;
        input = this.readAnswer();
        if (input == null) {
            throw new IOException("ProB binary returned nothing - it might have crashed");
        }
        return input;
    }

    protected String readAnswer() throws IOException {
        StringBuilder result = new StringBuilder();
        byte[] buffer = new byte[1024];
        boolean done = false;
        while (!done) {
            this.busy = true;
            int count = this.inputStream.read(buffer);
            this.busy = false;
            if (count > 0) {
                boolean length = true;
                if (buffer[count - 1] == 1) {
                    done = true;
                    --count;
                }
                String s = new String(buffer, 0, count, Charset.defaultCharset().name());
                result.append(s.replace("\r", "").replace("\n", ""));
                continue;
            }
            done = true;
        }
        return result.length() > 0 ? result.toString() : null;
    }

    private boolean isStreamReady() {
        if (this.inputStream == null || this.outputStream == null) {
            this.logger.warn("Stream to ProB server not ready");
            return false;
        }
        return true;
    }

    public void disconnect() {
        this.shutingDown = true;
    }

    public String getKey() {
        return this.key;
    }
}

