/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.IAnimator;
import de.prob.animator.command.AbstractCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermDelegate;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;

public class ComposedCommand
extends AbstractCommand {
    private static final char[] LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final AbstractCommand[] cmds;

    public ComposedCommand(AbstractCommand ... cmds) {
        this.cmds = cmds;
    }

    public ComposedCommand(List<? extends AbstractCommand> cmds) {
        this.cmds = cmds.toArray(new AbstractCommand[cmds.size()]);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrefixMap<PrologTerm> prefixMap = new PrefixMap<PrologTerm>(bindings);
        for (int i = 0; i < this.cmds.length; ++i) {
            this.processPrefixedCommand(prefixMap, i);
        }
    }

    private void processPrefixedCommand(PrefixMap<PrologTerm> prefixMap, int i) {
        ((PrefixMap)prefixMap).prefix = this.createPrefix(i);
        this.cmds[i].processResult(prefixMap);
    }

    @Override
    public void writeCommand(IPrologTermOutput orig) {
        PrologPrefixVarOutput pto = new PrologPrefixVarOutput(orig);
        for (int i = 0; i < this.cmds.length; ++i) {
            this.writePrefixedCommand(pto, i);
        }
    }

    private void writePrefixedCommand(PrologPrefixVarOutput pto, int i) {
        pto.prefix = this.createPrefix(i);
        this.cmds[i].writeCommand((IPrologTermOutput)pto);
    }

    public String createPrefix(int i) {
        if (i < LETTERS.length) {
            return String.valueOf(LETTERS[i]);
        }
        int letternum = i % LETTERS.length;
        int number = i / LETTERS.length;
        return String.valueOf(LETTERS[letternum]) + number;
    }

    public void getResultForCommand(AbstractCommand command, ISimplifiedROMap<String, PrologTerm> bindings) {
        int index = this.indexOf(command);
        if (index < 0 || index == this.cmds.length) {
            throw new IllegalArgumentException("cannot reprocess command, command unknown");
        }
        PrefixMap<PrologTerm> prefixMap = new PrefixMap<PrologTerm>(bindings);
        this.processPrefixedCommand(prefixMap, index);
    }

    private int indexOf(AbstractCommand command) {
        int index;
        for (index = 0; index < this.cmds.length && !this.cmds[index].equals(command); ++index) {
        }
        return index;
    }

    public AbstractCommand[] runInDebugMode(IAnimator animator) {
        for (AbstractCommand cmd : this.cmds) {
            animator.execute(cmd);
        }
        return this.cmds;
    }

    @Override
    public List<AbstractCommand> getSubcommands() {
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
        for (AbstractCommand iCommand : this.cmds) {
            commands.add(iCommand);
        }
        return commands;
    }

    private static final class PrefixMap<V>
    implements ISimplifiedROMap<String, V> {
        private final ISimplifiedROMap<String, V> map;
        private String prefix;

        public PrefixMap(ISimplifiedROMap<String, V> map) {
            this.map = map;
        }

        public V get(String key) {
            return (V)this.map.get((Object)(this.prefix == null ? key : this.prefix + key));
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static final class PrologPrefixVarOutput
    extends PrologTermDelegate {
        private String prefix;

        public PrologPrefixVarOutput(IPrologTermOutput pto) {
            super(pto);
        }

        public IPrologTermOutput printVariable(String var) {
            this.pto.printVariable(this.prefix == null ? var : this.prefix + var);
            return this;
        }

        public IPrologTermOutput fullstop() {
            return this;
        }
    }
}

