/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator;

import de.prob.animator.IPrologResult;
import de.prob.animator.InterruptedResult;
import de.prob.animator.NoResult;
import de.prob.animator.SimplifiedROMap;
import de.prob.animator.YesResult;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IRawCommand;
import de.prob.cli.ProBInstance;
import de.prob.core.sablecc.node.AExceptionResult;
import de.prob.core.sablecc.node.AInterruptedResult;
import de.prob.core.sablecc.node.ANoResult;
import de.prob.core.sablecc.node.AYesResult;
import de.prob.core.sablecc.node.PResult;
import de.prob.core.sablecc.node.Start;
import de.prob.exception.ProBError;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ProBResultParser;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermStringOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.Map;

class CommandProcessor {
    private ProBInstance cli;

    CommandProcessor() {
    }

    public IPrologResult sendCommand(AbstractCommand command) {
        String query = "";
        if (command instanceof IRawCommand) {
            query = ((IRawCommand)((Object)command)).getCommand();
            if (!query.endsWith(".")) {
                query = query + ".";
            }
        } else {
            PrologTermStringOutput pto = new PrologTermStringOutput();
            command.writeCommand((IPrologTermOutput)pto);
            pto.printAtom("true");
            query = pto.fullstop().toString();
        }
        String result = this.cli.send(query);
        Start ast = this.parseResult(result);
        return this.extractResult(ast);
    }

    private IPrologResult extractResult(Start ast) {
        PResult topnode = ast.getPResult();
        if (topnode instanceof ANoResult) {
            return new NoResult();
        }
        if (topnode instanceof AInterruptedResult) {
            return new InterruptedResult();
        }
        if (topnode instanceof AYesResult) {
            Map binding = BindingGenerator.createBinding((Start)ast);
            return new YesResult(new SimplifiedROMap<String, PrologTerm>(binding));
        }
        if (topnode instanceof AExceptionResult) {
            AExceptionResult r = (AExceptionResult)topnode;
            String message = r.getString().getText();
            throw new ProBError(message);
        }
        throw new ProBError("unknown prolog result " + ast);
    }

    private Start parseResult(String input) {
        if (input == null) {
            return null;
        }
        return ProBResultParser.parse((String)input);
    }

    public void configure(ProBInstance cli) {
        this.cli = cli;
    }
}

