/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorArgument;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.ast.datatype.ConstructorExtension;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.TypeSubstitution;

public final class ConstructorPredicateBuilder {
    private static final String PARAM_PREFIX = "p";
    private static final Predicate[] NO_PRED = new Predicate[0];
    private final Datatype datatype;
    private final ConstructorExtension constructor;
    private final IConstructorArgument[] arguments;
    private final int nbArgs;
    private final BoundIdentDecl[] bids;
    private final Expression[] bis;
    private FormulaFactory ff;

    public static final Predicate makeInConstructorDomain(Expression dtValue, ConstructorExtension constructor) {
        ConstructorPredicateBuilder builder = new ConstructorPredicateBuilder(constructor);
        return builder.makePredicate(dtValue);
    }

    private ConstructorPredicateBuilder(ConstructorExtension constructor) {
        this.datatype = constructor.getOrigin();
        this.constructor = constructor;
        this.arguments = constructor.getArguments();
        this.nbArgs = this.arguments.length;
        this.bids = new BoundIdentDecl[this.nbArgs];
        this.bis = new BoundIdentifier[this.nbArgs];
    }

    private Predicate makePredicate(Expression dtValue) {
        this.ff = dtValue.getFactory();
        Type dtType = dtValue.getType();
        this.makeIdentifiers(dtType);
        ExtendedExpression constr = this.ff.makeExtendedExpression((IExpressionExtension)this.constructor, this.bis, NO_PRED, null, dtType);
        RelationalPredicate eqDtConstr = this.ff.makeRelationalPredicate(101, (Expression)dtValue.shiftBoundIdentifiers(this.nbArgs), constr, null);
        return this.ff.makeQuantifiedPredicate(852, this.bids, (Predicate)eqDtConstr, null);
    }

    public void makeIdentifiers(Type dtType) {
        TypeSubstitution inst = this.datatype.getTypeInstantiation(dtType);
        for (int i = 0; i < this.nbArgs; ++i) {
            String bidName = this.makeBoundName(i);
            Type argType = this.arguments[i].getType(inst);
            this.bids[i] = this.ff.makeBoundIdentDecl(bidName, null, argType);
            this.bis[i] = this.ff.makeBoundIdentifier(this.nbArgs - i - 1, null, argType);
        }
    }

    private String makeBoundName(int index) {
        IConstructorArgument arg = this.arguments[index];
        if (arg.isDestructor()) {
            return arg.asDestructor().getName() + index;
        }
        return PARAM_PREFIX + index;
    }
}

