/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.HashSet;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ISpecialization;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProductType;
import org.eventb.internal.core.ast.Specialization;
import org.eventb.internal.core.ast.TypeRewriter;
import org.eventb.internal.core.ast.TypeTranslatabilityChecker;

public abstract class Type {
    private Expression expr = null;
    private final FormulaFactory fac;
    private final boolean solved;

    protected Type(FormulaFactory fac, boolean solved) {
        this(fac, solved, null);
    }

    protected Type(FormulaFactory fac, boolean solved, Expression expr) {
        this.fac = fac;
        this.solved = solved;
        this.expr = expr;
    }

    protected abstract Expression buildExpression(FormulaFactory var1);

    protected abstract void buildString(StringBuilder var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean isSolved() {
        return this.solved;
    }

    public FormulaFactory getFactory() {
        return this.fac;
    }

    protected void ensureSameFactory(Type[] types) {
        for (Type type : types) {
            this.ensureSameFactory(type);
        }
    }

    protected void ensureSameFactory(Type left, Type right) {
        this.ensureSameFactory(left);
        this.ensureSameFactory(right);
    }

    protected void ensureSameFactory(Type other) {
        FormulaFactory otherFactory = other.getFactory();
        if (this.fac != otherFactory) {
            throw new IllegalArgumentException("The type " + other + " has an incompatible factory: " + otherFactory + " instead of: " + this.fac);
        }
    }

    public Expression toExpression() {
        if (this.expr == null) {
            this.expr = this.buildExpression(this.fac);
        }
        return this.expr;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.buildString(buffer);
        return buffer.toString();
    }

    public Type getSource() {
        Type baseType;
        if (this instanceof PowerSetType && (baseType = ((PowerSetType)this).getBaseType()) instanceof ProductType) {
            return ((ProductType)baseType).getLeft();
        }
        return null;
    }

    public Type getTarget() {
        Type baseType;
        if (this instanceof PowerSetType && (baseType = ((PowerSetType)this).getBaseType()) instanceof ProductType) {
            return ((ProductType)baseType).getRight();
        }
        return null;
    }

    protected boolean isRelational() {
        Type baseType;
        return this instanceof PowerSetType && (baseType = ((PowerSetType)this).getBaseType()) instanceof ProductType;
    }

    public Type getBaseType() {
        return null;
    }

    protected abstract void addGivenTypes(Set<GivenType> var1);

    public final Set<GivenType> getGivenTypes() {
        HashSet<GivenType> result = new HashSet<GivenType>();
        this.addGivenTypes(result);
        return result;
    }

    public final Type specialize(ISpecialization specialization) {
        return ((Specialization)specialization).specialize(this);
    }

    public abstract void accept(ITypeVisitor var1);

    public boolean isTranslatable(FormulaFactory ff) {
        return TypeTranslatabilityChecker.isTranslatable(this, ff);
    }

    public Type translate(FormulaFactory ff) {
        if (this.fac == ff) {
            return this;
        }
        TypeRewriter rewriter = new TypeRewriter(ff);
        return rewriter.rewrite(this);
    }
}

