/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.SemanticNode;
import tlc2.util.Context;
import tlc2.value.MVPerm;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;

public class LazyValue
extends Value {
    public SemanticNode expr;
    public Context con;
    public Value val;

    public LazyValue(SemanticNode expr, Context con) {
        this.expr = expr;
        this.con = con;
        this.val = null;
    }

    public final void setUncachable() {
        this.val = ValUndef;
    }

    @Override
    public final byte getKind() {
        return 25;
    }

    @Override
    public final int compareTo(Object obj) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to compare lazy values.");
        }
        return this.val.compareTo(obj);
    }

    public final boolean equals(Object obj) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to check equality of lazy values.");
        }
        return this.val.equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to check set membership of lazy values.");
        }
        return this.val.member(elem);
    }

    @Override
    public final boolean isFinite() {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to check if a lazy value is a finite set.");
        }
        return this.val.isFinite();
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.");
        }
        return this.val.takeExcept(ex);
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.");
        }
        return this.val.takeExcept(exs);
    }

    @Override
    public final int size() {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to compute size of lazy value.");
        }
        return this.val.size();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.val = (Value)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to serialize lazy value.");
        }
        oos.writeObject(this.val);
    }

    @Override
    public final boolean isNormalized() {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to normalize lazy value.");
        }
        return this.val.isNormalized();
    }

    @Override
    public final void normalize() {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to normalize lazy value.");
        }
        this.val.normalize();
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        if (this.val == null || this.val == ValUndef) {
            return this;
        }
        return this.val.deepCopy();
    }

    @Override
    public final boolean assignable(Value val) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to call assignable on lazy value.");
        }
        return this.val.assignable(val);
    }

    @Override
    public final long fingerPrint(long fp) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to fingerprint a lazy value.");
        }
        return this.val.fingerPrint(fp);
    }

    @Override
    public final Value permute(MVPerm perm) {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to apply permutation to lazy value.");
        }
        return this.val.permute(perm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        if (this.val == null || this.val == ValUndef) {
            return sb.append("<LAZY " + this.expr + ">");
        }
        return this.val.toString(sb, offset);
    }
}

