/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class OpDeclNode
extends OpDefOrDeclNode {
    public OpDeclNode(UniqueString us, int kind, int level, int arity, ModuleNode mn, SymbolTable symbolTable, TreeNode stn) {
        super(us, kind, arity, mn, symbolTable, stn);
        this.level = level;
        if (this.getKind() == 2) {
            this.levelParams.add(this);
            this.allParams.add(this);
        }
        this.levelChecked = 1;
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    @Override
    public final boolean isLocal() {
        return false;
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    @Override
    public final boolean match(OpApplNode oa, ModuleNode mn) {
        ExprOrOpArgNode[] args = oa.getArgs();
        if (args == null || this.arity != args.length) {
            errors.addError(oa.getTreeNode().getLocation(), "Operator used with the wrong number of arguments.");
            return false;
        }
        return true;
    }

    @Override
    public final boolean levelCheck(int iter) {
        return true;
    }

    @Override
    public final void walkGraph(Hashtable semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(new Integer(this.myUID), this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "\n*OpDeclNode: " + this.getName() + "  " + super.toString(depth) + "\n  originallyDefinedInModule: " + (this.originallyDefinedInModule != null ? this.originallyDefinedInModule.getName().toString() : "<null>");
    }

    @Override
    protected String getNodeRef() {
        return "OpDeclNodeRef";
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context) {
        Element e = doc.createElement("OpDeclNode");
        e.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        e.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
        e.appendChild(this.appendText(doc, "kind", Integer.toString(this.getKind())));
        return e;
    }
}

