/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.model.eventb.EventBModel;
import de.prob.model.eventb.translate.ContextXmlHandler;
import de.prob.model.eventb.translate.MachineXmlHandler;
import de.prob.model.eventb.translate.TheoryXmlHandler;
import de.prob.model.representation.AbstractElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EventBDatabaseTranslator {
    private AbstractElement mainComponent;
    private EventBModel model;

    public EventBDatabaseTranslator(EventBModel m, String fileName) throws FileNotFoundException {
        block8: {
            try {
                HashSet<IFormulaExtension> typeEnv;
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = parserFactory.newSAXParser();
                File modelFile = new File(fileName);
                String fullFileName = modelFile.getAbsolutePath();
                this.model = m.setModelFile(modelFile);
                String directory = fullFileName.substring(0, fullFileName.lastIndexOf(File.separatorChar));
                String workspacePath = directory.substring(0, directory.lastIndexOf(File.separatorChar));
                File theoryFile = new File(directory + File.separator + "TheoryPath.tcl");
                if (!theoryFile.exists()) {
                    typeEnv = new HashSet();
                } else {
                    TheoryXmlHandler theoryHandler = new TheoryXmlHandler(this.model, workspacePath);
                    saxParser.parse(theoryFile, (DefaultHandler)theoryHandler);
                    typeEnv = theoryHandler.getTypeEnv();
                    this.model = theoryHandler.getModel();
                }
                DefaultHandler xmlHandler = null;
                this.mainComponent = null;
                if (fileName.endsWith(".bcc")) {
                    xmlHandler = new ContextXmlHandler(this.model, fullFileName, typeEnv);
                    saxParser.parse(modelFile, xmlHandler);
                    this.mainComponent = ((ContextXmlHandler)xmlHandler).getContext();
                    this.model = ((ContextXmlHandler)xmlHandler).getModel();
                } else {
                    xmlHandler = new MachineXmlHandler(this.model, fullFileName, typeEnv);
                    saxParser.parse(modelFile, xmlHandler);
                    this.mainComponent = ((MachineXmlHandler)xmlHandler).getMachine();
                    this.model = ((MachineXmlHandler)xmlHandler).getModel();
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                if (!(e instanceof FileNotFoundException)) break block8;
                throw (FileNotFoundException)e;
            }
        }
    }

    public AbstractElement getMainComponent() {
        return this.mainComponent;
    }

    public EventBModel getModel() {
        return this.model;
    }
}

