/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.Context;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.EventBConstant;
import de.prob.model.eventb.EventBModel;
import de.prob.model.eventb.ProofObligation;
import de.prob.model.eventb.translate.ProofExtractor;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.Axiom;
import de.prob.model.representation.Constant;
import de.prob.model.representation.DependencyGraph;
import de.prob.model.representation.ModelElementList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextXmlHandler
extends DefaultHandler {
    private EventBModel model;
    private final Set<IFormulaExtension> typeEnv;
    private final String directoryPath;
    private final List<String> extendsNames = new ArrayList<String>();
    private Context context;
    private final List<Context> Extends = new ArrayList<Context>();
    private final List<de.prob.model.representation.Set> sets = new ArrayList<de.prob.model.representation.Set>();
    private final List<EventBAxiom> axioms = new ArrayList<EventBAxiom>();
    private final List<EventBAxiom> inheritedAxioms = new ArrayList<EventBAxiom>();
    private final List<EventBConstant> constants = new ArrayList<EventBConstant>();
    private Context internalContext;
    private List<Context> internalExtends;
    private List<de.prob.model.representation.Set> internalSets;
    private List<EventBAxiom> internalAxioms;
    private List<EventBAxiom> internalInheritedAxioms;
    private List<EventBConstant> internalConstants;
    private boolean inInternalContext;
    private final Map<String, Map<String, EventBAxiom>> axiomCache = new HashMap<String, Map<String, EventBAxiom>>();

    public ContextXmlHandler(EventBModel model, String fileName, Set<IFormulaExtension> typeEnv) {
        this.model = model;
        this.typeEnv = typeEnv;
        String name = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf("."));
        this.directoryPath = fileName.substring(0, fileName.lastIndexOf(File.separatorChar));
        this.context = new Context(name);
        this.axiomCache.put(name, new HashMap());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("org.eventb.core.scInternalContext")) {
            this.beginInternalContextExtraction(attributes);
        } else if (qName.equals("org.eventb.core.scExtendsContext")) {
            this.addExtendedContext(attributes);
        } else if (qName.equals("org.eventb.core.scAxiom")) {
            this.addAxiom(attributes);
        } else if (qName.equals("org.eventb.core.scConstant")) {
            this.addConstant(attributes);
        } else if (qName.equals("org.eventb.core.scCarrierSet")) {
            this.addSet(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("org.eventb.core.scInternalContext")) {
            this.endInternalContextExtraction();
        }
    }

    private void addSet(Attributes attributes) {
        String name = attributes.getValue("name");
        de.prob.model.representation.Set bSet = new de.prob.model.representation.Set(new EventB(name));
        if (this.inInternalContext) {
            this.internalSets.add(bSet);
        } else {
            this.sets.add(bSet);
        }
    }

    private void addConstant(Attributes attributes) {
        String name = attributes.getValue("name");
        boolean symbolic = "true".equals(attributes.getValue("de.prob.symbolic.symbolicAttribute"));
        String unit = attributes.getValue("de.prob.units.unitPragmaAttribute");
        if (this.inInternalContext) {
            this.internalConstants.add(new EventBConstant(name, symbolic, unit));
        } else {
            this.constants.add(new EventBConstant(name, symbolic, unit));
        }
    }

    private void addAxiom(Attributes attributes) {
        String source = attributes.getValue("org.eventb.core.source");
        String internalName = source.substring(source.lastIndexOf(35) + 1, source.length());
        String filePath = source.substring(0, source.indexOf(124));
        String contextName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf("."));
        String label = attributes.getValue("org.eventb.core.label");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        boolean theorem = attributes.getValue("org.eventb.core.theorem").equals("true");
        if (this.inInternalContext) {
            if (contextName.equals(this.internalContext.getName())) {
                EventBAxiom axiom = new EventBAxiom(label, predicate, theorem, this.typeEnv);
                this.internalAxioms.add(axiom);
                this.axiomCache.get(this.internalContext.getName()).put(internalName, axiom);
            } else {
                this.internalInheritedAxioms.add(this.axiomCache.get(contextName).get(internalName));
            }
        } else if (contextName.equals(this.context.getName())) {
            EventBAxiom axiom = new EventBAxiom(label, predicate, theorem, this.typeEnv);
            this.axioms.add(axiom);
            this.axiomCache.get(this.context.getName()).put(internalName, axiom);
        } else {
            this.inheritedAxioms.add(this.axiomCache.get(contextName).get(internalName));
        }
    }

    private void addExtendedContext(Attributes attributes) {
        AbstractElement component;
        String source = attributes.getValue("org.eventb.core.scTarget");
        String contextName = source.substring(source.lastIndexOf(35) + 1, source.length());
        this.model.addRelationship(this.context.getName(), contextName, DependencyGraph.ERefType.EXTENDS);
        if (!this.inInternalContext) {
            this.extendsNames.add(contextName);
        }
        if ((component = this.model.getComponent(contextName)) != null) {
            if (this.inInternalContext) {
                this.internalExtends.add((Context)component);
            } else {
                this.Extends.add((Context)component);
            }
        }
    }

    private void beginInternalContextExtraction(Attributes attributes) {
        String name = attributes.getValue("name");
        this.inInternalContext = true;
        this.internalContext = new Context(name);
        this.axiomCache.put(name, new HashMap());
        this.internalExtends = new ArrayList<Context>();
        this.internalAxioms = new ArrayList<EventBAxiom>();
        this.internalInheritedAxioms = new ArrayList<EventBAxiom>();
        this.internalSets = new ArrayList<de.prob.model.representation.Set>();
        this.internalConstants = new ArrayList<EventBConstant>();
    }

    private void endInternalContextExtraction() throws SAXException {
        ModelElementList<EventBAxiom> axms = new ModelElementList<EventBAxiom>(this.internalInheritedAxioms);
        axms = axms.addMultiple(this.internalAxioms);
        this.internalContext = this.internalContext.set(Axiom.class, axms);
        this.internalContext = this.internalContext.set(Constant.class, new ModelElementList<EventBConstant>(this.internalConstants));
        this.internalContext = this.internalContext.set(Context.class, new ModelElementList<Context>(this.internalExtends));
        this.internalContext = this.internalContext.set(de.prob.model.representation.Set.class, new ModelElementList<de.prob.model.representation.Set>(this.internalSets));
        ProofExtractor extractor = new ProofExtractor(this.internalContext, this.directoryPath + File.separatorChar + this.internalContext.getName());
        this.internalContext = this.internalContext.set(ProofObligation.class, extractor.getProofs());
        if (this.extendsNames.contains(this.internalContext.getName())) {
            this.Extends.add(this.internalContext);
        }
        this.model = this.model.addContext(this.internalContext);
        this.inInternalContext = false;
    }

    @Override
    public void endDocument() throws SAXException {
        ModelElementList<EventBAxiom> axms = new ModelElementList<EventBAxiom>(this.inheritedAxioms);
        axms = axms.addMultiple(this.axioms);
        this.context = this.context.set(Axiom.class, axms);
        this.context = this.context.set(Constant.class, new ModelElementList<EventBConstant>(this.constants));
        this.context = this.context.set(Context.class, new ModelElementList<Context>(this.Extends));
        this.context = this.context.set(de.prob.model.representation.Set.class, new ModelElementList<de.prob.model.representation.Set>(this.sets));
        ProofExtractor extractor = new ProofExtractor(this.context, this.directoryPath + File.separatorChar + this.context.getName());
        this.context = this.context.set(ProofObligation.class, extractor.getProofs());
        this.model = this.model.addContext(this.context);
    }

    public Context getContext() {
        return this.context;
    }

    public EventBModel getModel() {
        return this.model;
    }
}

