/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Provides;
import de.prob.cli.OsInfoProvider;
import de.prob.cli.OsSpecificInfo;
import de.prob.cli.ProBInstance;
import de.prob.cli.ProBInstanceProvider;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class ModuleCli
extends AbstractModule {
    protected void configure() {
        this.bind(ProBInstance.class).toProvider(ProBInstanceProvider.class);
        this.bind(OsSpecificInfo.class).toProvider(OsInfoProvider.class).asEagerSingleton();
    }

    @Provides
    @OsName
    public String getOsName() {
        return System.getProperty("os.name");
    }

    @Provides
    @OsArch
    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    @Provides
    @DebuggingKey
    public String createDebuggingKey() {
        Random random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            random = new Random();
        }
        return Long.toHexString(random.nextLong());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface OsArch {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface DebuggingKey {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface OsName {
    }
}

