/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import de.prob.cli.ProBInstance;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;

final class ConsoleListener
implements Runnable {
    private final WeakReference<ProBInstance> cli;
    private final BufferedReader stream;
    private final Logger logger;

    ConsoleListener(ProBInstance cli, BufferedReader stream, Logger logger) {
        this.cli = new WeakReference<ProBInstance>(cli);
        this.stream = stream;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logLines();
        }
        catch (IOException e) {
            if (!"Stream closed".equals(e.getMessage())) {
                String message = "OutputLogger died with error";
                this.logger.info("OutputLogger died with error", (Throwable)e);
            }
        }
        finally {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void logLines() throws IOException {
        String line = null;
        do {
            ProBInstance instance;
            if ((instance = (ProBInstance)this.cli.get()) == null || instance.isShuttingDown()) {
                return;
            }
            instance = null;
        } while ((line = this.readAndLog()) != null);
    }

    String readAndLog() throws IOException {
        String line = this.stream.readLine();
        if (line != null) {
            this.logger.debug(line);
        }
        return line;
    }
}

