/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ComputeCoverageCommand;
import de.prob.check.IModelCheckJob;
import de.prob.check.IModelCheckingResult;
import de.prob.statespace.StateSpace;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ModelChecker {
    private static int counter = 0;
    private static String JOBPREFIX = "mc";
    private final ExecutorService executor;
    private Future<IModelCheckingResult> f;
    private final String jobId;
    private final StateSpace stateSpace;
    private final IModelCheckJob job;

    public static String generateJobId() {
        return JOBPREFIX + counter++;
    }

    public ModelChecker(IModelCheckJob job) {
        this.job = job;
        this.jobId = job.getJobId();
        this.stateSpace = job.getStateSpace();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean cancel() {
        if (!this.isDone()) {
            this.stateSpace.sendInterrupt();
            return this.f.cancel(true);
        }
        return false;
    }

    public IModelCheckingResult getResult() {
        try {
            if (this.f != null) {
                return this.f.get();
            }
        }
        catch (InterruptedException e) {
            this.f.cancel(true);
        }
        catch (ExecutionException e) {
            ModelChecker.launderThrowable(e.getCause());
        }
        catch (CancellationException e) {
            return this.job.getResult();
        }
        return null;
    }

    public void start() {
        this.f = this.executor.submit(this.job);
    }

    public boolean isStarted() {
        return this.f != null;
    }

    public boolean isDone() {
        return this.f != null && this.f.isDone();
    }

    public boolean isCancelled() {
        if (this.f == null) {
            return false;
        }
        return this.f.isCancelled();
    }

    public StateSpace getStateSpace() {
        return this.stateSpace;
    }

    public ComputeCoverageCommand.ComputeCoverageResult getCoverage() {
        ComputeCoverageCommand cmd = new ComputeCoverageCommand();
        this.stateSpace.execute((AbstractCommand)cmd);
        return cmd.getResult();
    }

    public static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }
}

