/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.check.IModelCheckingResult;
import de.prob.check.ModelCheckErrorUncovered;
import de.prob.check.ModelCheckOk;
import de.prob.check.ModelCheckingOptions;
import de.prob.check.NotYetFinished;
import de.prob.check.StateSpaceStats;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCheckingStepCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "do_modelchecking";
    private static final int STATS_ARITY = 3;
    private final int time;
    private final ModelCheckingOptions options;
    private IModelCheckingResult result;
    private final String RESULT = "Result";
    private final String STATS = "Stats";
    Logger logger = LoggerFactory.getLogger(ModelCheckingStepCommand.class);
    private StateSpaceStats stats;

    public ModelCheckingStepCommand(int time, ModelCheckingOptions options) {
        this.time = time;
        this.options = options;
    }

    public IModelCheckingResult getResult() {
        return this.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        CompoundPrologTerm statsTerm = BindingGenerator.getCompoundTerm((PrologTerm)((PrologTerm)bindings.get((Object)"Stats")), (int)3);
        int numberNodes = BindingGenerator.getInteger((PrologTerm)statsTerm.getArgument(1)).getValue().intValue();
        int numberTrans = BindingGenerator.getInteger((PrologTerm)statsTerm.getArgument(2)).getValue().intValue();
        int numberProcessed = BindingGenerator.getInteger((PrologTerm)statsTerm.getArgument(3)).getValue().intValue();
        this.stats = new StateSpaceStats(numberNodes, numberTrans, numberProcessed);
        this.result = this.extractResult((PrologTerm)bindings.get((Object)"Result"));
    }

    private IModelCheckingResult extractResult(PrologTerm prologTerm) {
        CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)prologTerm, (int)prologTerm.getArity());
        String type = cpt.getFunctor();
        if (type.equals("not_yet_finished")) {
            int maxNodesLeft = BindingGenerator.getInteger((PrologTerm)cpt.getArgument(1)).getValue().intValue();
            return new NotYetFinished("Model checking not completed", maxNodesLeft);
        }
        if (type.equals("ok")) {
            return new ModelCheckOk("Model Checking complete. No error nodes found.");
        }
        if (type.equals("full_coverage")) {
            return new ModelCheckOk("Model Checking complete. All operations were covered.");
        }
        if (type.equals("ok_not_all_nodes_considered")) {
            return new ModelCheckOk("Model Checking complete. No error nodes found. Not all nodes were considered.");
        }
        if (type.equals("deadlock")) {
            return new ModelCheckErrorUncovered("Deadlock found.", cpt.getArgument(1).getFunctor());
        }
        if (type.equals("invariant_violation")) {
            return new ModelCheckErrorUncovered("Invariant violation found.", cpt.getArgument(1).getFunctor());
        }
        if (type.equals("assertion_violation")) {
            return new ModelCheckErrorUncovered("Assertion violation found.", cpt.getArgument(1).getFunctor());
        }
        if (type.equals("state_error")) {
            return new ModelCheckErrorUncovered("A state error occured.", cpt.getArgument(1).getFunctor());
        }
        if (type.equals("goal_found")) {
            return new ModelCheckErrorUncovered("Goal found", cpt.getArgument(1).getFunctor());
        }
        if (type.equals("well_definedness_error")) {
            return new ModelCheckErrorUncovered("A well definedness error occured.", cpt.getArgument(1).getFunctor());
        }
        if (type.equals("general_error")) {
            return new ModelCheckErrorUncovered("An unknown result was uncovered: " + cpt.getArgument(2).toString(), cpt.getArgument(1).getFunctor());
        }
        this.logger.error("Model checking result unknown. " + cpt.toString());
        throw new IllegalArgumentException("model checking result unknown: " + cpt.toString());
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printNumber((long)this.time).openList();
        for (ModelCheckingOptions.Options o : this.options.getPrologOptions()) {
            pto.printAtom(o.name());
        }
        pto.closeList().printVariable("Result").printVariable("Stats").closeTerm();
    }

    public StateSpaceStats getStats() {
        return this.stats;
    }
}

