/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.FormulaId;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public class InsertFormulaForVisualizationCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "insert_formula_for_expansion";
    private final IEvalElement formula;
    private final String ID = "Id";
    private FormulaId formulaId;

    public InsertFormulaForVisualizationCommand(IEvalElement formula) {
        this.formula = formula;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        this.formula.printProlog(pto);
        pto.printVariable("Id");
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm prologTerm = (PrologTerm)bindings.get((Object)"Id");
        this.formulaId = new FormulaId(prologTerm.getFunctor(), this.formula);
    }

    public FormulaId getFormulaId() {
        return this.formulaId;
    }
}

