/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.EvalElementType;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;

public class GetStatesFromPredicate
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "get_states_for_predicate";
    private final IEvalElement formula;
    private final String STATES = "States";
    private final String ERRORS = "Errors";
    private final List<String> ids = new ArrayList<String>();

    public GetStatesFromPredicate(IEvalElement e) {
        if (!e.getKind().equals(EvalElementType.PREDICATE.toString())) {
            throw new IllegalArgumentException("Formula in GetStatesFromPredicate must be a predicate");
        }
        this.formula = e;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        this.formula.printProlog(pto);
        pto.printVariable("States");
        pto.printVariable("Errors");
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm list = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"States")));
        for (PrologTerm prologTerm : list) {
            this.ids.add(Transition.getIdFromPrologTerm(prologTerm));
        }
    }

    public List<String> getIds() {
        return this.ids;
    }
}

