/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.EvalResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvaluateRegisteredFormulasCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "evaluate_registered_formulas";
    private final String RESULTS = "Results";
    private final String stateId;
    private final Map<IEvalElement, AbstractEvalResult> results = new HashMap<IEvalElement, AbstractEvalResult>();
    private final List<IEvalElement> formulas;

    public EvaluateRegisteredFormulasCommand(String stateId, Collection<IEvalElement> formulas) {
        this.stateId = stateId;
        this.formulas = new ArrayList<IEvalElement>(formulas);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtomOrNumber(this.stateId);
        pto.openList();
        for (IEvalElement formula : this.formulas) {
            formula.getFormulaId().printUUID(pto);
        }
        pto.closeList();
        pto.printVariable("Results");
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm terms = (PrologTerm)bindings.get((Object)"Results");
        if (terms instanceof ListPrologTerm) {
            ListPrologTerm lpt = BindingGenerator.getList((PrologTerm)terms);
            for (int i = 0; i < lpt.size(); ++i) {
                PrologTerm pt = lpt.get(i);
                IEvalElement key = this.formulas.get(i);
                this.results.put(key, EvalResult.getEvalResult(pt));
            }
        }
    }

    public Map<IEvalElement, AbstractEvalResult> getResults() {
        return this.results;
    }

    public String getStateId() {
        return this.stateId;
    }
}

