/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import de.prob.annotations.Dangerous;
import de.prob.scripting.ScriptEngineProvider;
import de.prob.web.AbstractSession;
import de.prob.web.ReflectionServlet;
import de.prob.web.WebUtils;
import de.prob.web.data.SessionResult;
import de.prob.web.worksheet.BindingsSnapshot;
import de.prob.web.worksheet.BoxFactory;
import de.prob.web.worksheet.EChangeEffect;
import de.prob.web.worksheet.IBox;
import de.prob.web.worksheet.VariableDetailTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.script.ScriptEngine;
import javax.servlet.AsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dangerous
public class Worksheet
extends AbstractSession {
    private int boxcount = 0;
    private final Map<String, IBox> boxes = Collections.synchronizedMap(new HashMap());
    private final Map<String, BindingsSnapshot> snapshots = Collections.synchronizedMap(new HashMap());
    private final BoxFactory boxfactory;
    private String defaultboxtype = "Markdown";
    private volatile ScriptEngine groovy;
    private final Logger logger = LoggerFactory.getLogger(Worksheet.class);
    private final List<String> order = Collections.synchronizedList(new ArrayList());
    private final ScriptEngineProvider sep;
    private final ReflectionServlet servlet;

    @Inject
    public Worksheet(ScriptEngineProvider sep, BoxFactory boxfactory, ReflectionServlet servlet) {
        this.sep = sep;
        this.boxfactory = boxfactory;
        this.servlet = servlet;
        this.groovy = this.createGroovy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngine createGroovy() {
        ScriptEngineProvider scriptEngineProvider = this.sep;
        synchronized (scriptEngineProvider) {
            this.snapshots.clear();
            ScriptEngine g = this.sep.get();
            return g;
        }
    }

    private IBox appendFreshBox() {
        IBox box = this.makeBox(this.defaultboxtype);
        this.order.add(box.getId());
        return box;
    }

    public Object deleteBox(Map<String, String[]> params) {
        ArrayList<Object> messages = new ArrayList<Object>();
        String box = params.get("number")[0];
        this.logger.trace("Delete box {}", (Object)box);
        int index = this.order.indexOf(box);
        this.order.remove(index);
        IBox deleted = this.boxes.get(box);
        this.boxes.remove(box);
        Map<String, String> deleteCmd = WebUtils.wrap("cmd", "Worksheet.deleteBox", "id", box);
        messages.add(deleteCmd);
        if (this.order.size() == 0) {
            Map<String, String> renderCmd = this.appendFreshBox().createMessage();
            messages.add(renderCmd);
        } else if (index != this.order.size()) {
            messages.addAll(this.reEvaluate(deleted.changeEffect(), index));
        }
        return messages.toArray();
    }

    private String firstBox() {
        return this.order.isEmpty() ? null : this.order.get(0);
    }

    public ScriptEngine getGroovy() {
        return this.groovy;
    }

    private String getPredecessor(String boxId) {
        int index = this.order.indexOf(boxId) - 1;
        return this.order.get(index);
    }

    private String getSuccessor(String boxId) {
        int index = this.order.indexOf(boxId) + 1;
        return this.order.get(index);
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        ArrayList<Map<String, String>> scopes = new ArrayList<Map<String, String>>();
        scopes.add(WebUtils.wrap("clientid", clientid, "default-box-type", this.defaultboxtype));
        scopes.add(WebUtils.wrap("help-markdown", WebUtils.render("ui/worksheet/help_markdown.html", new Object[0])));
        String render = WebUtils.render("ui/worksheet/index.html", scopes.toArray());
        return render;
    }

    private String lastBox() {
        int index = this.order.size() - 1;
        return index >= 0 ? this.order.get(index) : null;
    }

    public Object leaveEditor(Map<String, String[]> params) {
        return this.leaveEditorMessages(params).toArray();
    }

    public List<Object> leaveEditorMessages(Map<String, String[]> params) {
        String boxId = params.get("box")[0];
        String direction = params.get("direction")[0];
        String text = params.get("text")[0];
        this.logger.trace("Leaving {} direction {}. Content {}", new Object[]{boxId, direction, text});
        ArrayList<Object> messages = new ArrayList<Object>();
        if ("down".equals(direction)) {
            messages.addAll(this.leaveEditorDown(boxId, text));
        }
        if ("up".equals(direction) && boxId.equals(this.firstBox())) {
            return null;
        }
        if ("up".equals(direction) && !boxId.equals(this.firstBox())) {
            messages.add(WebUtils.wrap("cmd", "Worksheet.unfocus", "number", boxId));
            String focused = this.getPredecessor(boxId);
            messages.add(WebUtils.wrap("cmd", "Worksheet.focus", "number", focused, "direction", "up"));
        }
        IBox box = this.boxes.get(boxId);
        box.setContent(params);
        messages.addAll(this.reEvaluate(boxId, this.order.indexOf(boxId)));
        return messages;
    }

    private List<Object> leaveEditorDown(String boxId, String text) {
        ArrayList<Object> res = new ArrayList<Object>();
        res.add(WebUtils.wrap("cmd", "Worksheet.unfocus", "number", boxId));
        if (boxId.equals(this.lastBox())) {
            res.add(this.appendFreshBox().createMessage());
        } else {
            String focused = this.getSuccessor(boxId);
            res.add(WebUtils.wrap("cmd", "Worksheet.focus", "number", focused, "direction", "down"));
        }
        return res;
    }

    public IBox makeBox(String type) {
        IBox box = this.boxfactory.create(this, this.boxcount++, type);
        this.boxes.put(box.getId(), box);
        return box;
    }

    private List<Object> reEvaluate(IBox box, EChangeEffect effect, int position) {
        switch (effect) {
            case DONT_CARE: {
                return this.render(box);
            }
            case EVERYTHING_BELOW: {
                return this.reEvaluateBoxes(position);
            }
        }
        return this.reEvaluateBoxes(0);
    }

    private List<Object> reEvaluate(String boxId, int position) {
        IBox box = this.boxes.get(boxId);
        EChangeEffect effect = box.changeEffect();
        return this.reEvaluate(box, effect, position);
    }

    private Collection<? extends Object> reEvaluate(EChangeEffect changeEffect, int index) {
        if (changeEffect == EChangeEffect.DONT_CARE) {
            return Collections.emptyList();
        }
        return this.reEvaluate(null, changeEffect, index);
    }

    private List<Object> reEvaluateBoxes(final int reorderposition) {
        if (reorderposition == 0) {
            this.groovy = this.createGroovy();
        }
        this.logger.trace("Re-Evaluating boxes, starting at box {}", (Object)reorderposition);
        final Worksheet delegate = this;
        Callable<SessionResult> invalidateCommand = new Callable<SessionResult>(){

            @Override
            public SessionResult call() throws Exception {
                ArrayList<Map<String, String>> messages = new ArrayList<Map<String, String>>();
                for (int i = reorderposition; i < Worksheet.this.order.size(); ++i) {
                    String id = (String)Worksheet.this.order.get(i);
                    IBox box = (IBox)Worksheet.this.boxes.get(id);
                    if (!box.requiresReEvaluation()) continue;
                    messages.add(WebUtils.wrap("cmd", "Worksheet.invalidate", "number", box.getId()));
                }
                return new SessionResult(delegate, messages.toArray());
            }
        };
        Callable<SessionResult> reEvalCommand = new Callable<SessionResult>(){

            @Override
            public SessionResult call() throws Exception {
                ArrayList messages = new ArrayList();
                for (int i = reorderposition; i < Worksheet.this.order.size(); ++i) {
                    String id = (String)Worksheet.this.order.get(i);
                    IBox box = (IBox)Worksheet.this.boxes.get(id);
                    if (!box.requiresReEvaluation()) continue;
                    messages.addAll(Worksheet.this.render(box));
                }
                return new SessionResult(delegate, messages.toArray());
            }
        };
        this.servlet.submit(invalidateCommand);
        this.servlet.submit(reEvalCommand);
        return Collections.emptyList();
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
    }

    private List<Object> render(IBox box) {
        Predicate<Map.Entry<String, Object>> p = new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(@Nullable Map.Entry<String, Object> input) {
                return !input.getKey().startsWith("__");
            }
        };
        Comparator<Map.Entry<String, Object>> comperator = new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };
        BindingsSnapshot previous_snapshot = box.getId().equals(this.order.get(0)) ? null : this.snapshots.get(this.getPredecessor(box.getId()));
        List<Object> box_rendering = box.render(previous_snapshot);
        BindingsSnapshot current_snapshot = new BindingsSnapshot(this.groovy);
        this.snapshots.put(box.getId(), current_snapshot);
        Collection bindings_global = Collections2.filter(this.groovy.getBindings(200).entrySet(), (Predicate)p);
        Collection bindings_local = Collections2.filter(this.groovy.getBindings(100).entrySet(), (Predicate)p);
        ArrayList vars = new ArrayList();
        vars.addAll(bindings_local);
        vars.addAll(bindings_global);
        Collections.sort(vars, comperator);
        VariableDetailTransformer toJson = new VariableDetailTransformer(previous_snapshot, current_snapshot);
        Collection vars2 = Collections2.transform(vars, (Function)toJson);
        Collection vars3 = Collections2.filter((Collection)vars2, (Predicate)new Predicate<Map<String, String>>(){

            public boolean apply(@Nullable Map<String, String> input) {
                return input != null;
            }
        });
        box_rendering.add(WebUtils.wrap("cmd", "Worksheet.aside", "number", box.getId(), "aside", WebUtils.toJson(vars3)));
        return box_rendering;
    }

    public Object refreshAll(Map<String, String[]> params) {
        ArrayList<Object> messages = new ArrayList<Object>();
        if (params.get("text") != null) {
            List<Object> leaveEditorMessages = this.leaveEditorMessages(params);
            messages.addAll(leaveEditorMessages);
        }
        messages.addAll(this.reEvaluateBoxes(0));
        return messages.toArray();
    }

    public Object reorder(Map<String, String[]> params) {
        String boxId = params.get("box")[0];
        int oldPos = this.order.indexOf(boxId);
        int newpos = Integer.parseInt(params.get("newpos")[0]);
        this.order.remove(boxId);
        this.order.add(newpos, boxId);
        int position = Math.min(oldPos, newpos);
        this.logger.trace("Reordered box {}. From {} to {}.", new Object[]{boxId, oldPos, newpos});
        return this.reEvaluate(boxId, position).toArray();
    }

    public Object setDefaultType(Map<String, String[]> params) {
        String type;
        this.defaultboxtype = type = params.get("type")[0];
        return WebUtils.wrap("cmd", "Worksheet.setDefaultType", "type", type);
    }

    public Object switchType(Map<String, String[]> params) {
        String type = params.get("type")[0];
        String id = params.get("box")[0];
        this.logger.trace("Switch type of {} to {}", (Object)id, (Object)type);
        IBox box = this.boxfactory.create(this, id, type);
        box.setContent(params);
        this.boxes.put(id, box);
        return box.replaceMessage();
    }
}

