/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ExpandFormulaCommand;
import de.prob.animator.command.InsertFormulaForVisualizationCommand;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.animator.domainobjects.EventB;
import de.prob.animator.domainobjects.ExpandedFormula;
import de.prob.animator.domainobjects.FormulaId;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.unicode.UnicodeTranslator;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.AsyncContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaView
extends AbstractAnimationBasedView {
    Logger logger = LoggerFactory.getLogger(FormulaView.class);
    private Trace currentTrace;
    private IEvalElement formula;
    private FormulaId setFormula;
    private final StateSpace currentStateSpace;
    private final Set<String> collapsedNodes = new CopyOnWriteArraySet<String>();

    @Inject
    public FormulaView(AnimationSelector animations) {
        super(animations);
        this.incrementalUpdate = false;
        this.currentTrace = this.getCurrentTrace();
        if (this.currentTrace == null) {
            this.currentStateSpace = null;
        } else {
            this.currentStateSpace = this.currentTrace.getStateSpace();
            animations.registerAnimationChangeListener((IAnimationChangeListener)this);
        }
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        if (this.currentStateSpace == null) {
            return "<html><head><title>Formula Visualization</title></head></html>";
        }
        return this.simpleRender(clientid, "ui/formulaView/index.html");
    }

    @Override
    public void performTraceChange(Trace trace) {
        this.currentTrace = trace;
        if (this.currentTrace != null && this.currentTrace.getStateSpace().equals(this.currentStateSpace)) {
            this.sendRefresh();
        }
    }

    private void sendRefresh() {
        Object data = this.calculateData();
        if (data != null) {
            Map<String, String> wrap = WebUtils.wrap("cmd", "FormulaView.draw", "data", data);
            this.submit(wrap);
        }
    }

    public Object calculateData() {
        if (this.setFormula != null) {
            ExpandFormulaCommand cmd = new ExpandFormulaCommand(this.setFormula, this.currentTrace.getCurrentState());
            this.currentStateSpace.execute((AbstractCommand)cmd);
            ExpandedFormula result = cmd.getResult();
            result.collapseNodes(new HashSet<String>(this.collapsedNodes));
            GsonBuilder b = new GsonBuilder();
            b.disableHtmlEscaping();
            Gson gson = b.create();
            String json = gson.toJson((Object)result.getFields());
            String j = json.replaceAll("\\\\u", "\\u");
            return j;
        }
        return null;
    }

    public Object setFormula(Map<String, String[]> params) {
        if (this.formula == null) {
            return this.sendError("Whoops!", "Could not add formula because it is invalid for this model", "alert-danger");
        }
        if (this.currentTrace == null) {
            return this.sendError("Sorry!", "Could not assert the validity of the formula because an animation is not loaded", "");
        }
        if (!(this.formula instanceof EventB) && !(this.formula instanceof ClassicalB)) {
            return this.sendError("Sorry!", "This visualization requires B-type formulas", "alert-danger");
        }
        try {
            InsertFormulaForVisualizationCommand cmd = new InsertFormulaForVisualizationCommand(this.formula);
            this.currentStateSpace.execute((AbstractCommand)cmd);
            this.setFormula = cmd.getFormulaId();
            Object data = this.calculateData();
            return WebUtils.wrap("cmd", "FormulaView.formulaSet", "formula", this.formula.getCode(), "unicode", StringEscapeUtils.escapeHtml((String)UnicodeTranslator.toUnicode((String)this.formula.getCode())), "data", data);
        }
        catch (Exception e) {
            return this.sendError("Whoops!", "Could not add formula because evaluation of the formula threw an exception of type " + e.getClass().getSimpleName(), "alert-danger");
        }
    }

    private Map<String, String> sendError(String emphasized, String msg, String level) {
        return WebUtils.wrap("cmd", "FormulaView.error", "msg", msg, "strong", emphasized, "alertLevel", level);
    }

    public Object parse(Map<String, String[]> params) {
        String f = params.get("formula")[0];
        try {
            IEvalElement e;
            this.formula = e = this.currentStateSpace.getModel().parseFormula(f);
            return WebUtils.wrap("cmd", "FormulaView.parseOk");
        }
        catch (Exception e) {
            this.formula = null;
            return WebUtils.wrap("cmd", "FormulaView.parseError");
        }
    }

    public Object removeFormula(Map<String, String[]> params) {
        this.formula = null;
        return WebUtils.wrap("cmd", "FormulaView.formulaRemoved");
    }

    public Object collapseNode(Map<String, String[]> params) {
        String id = params.get("formulaId")[0];
        this.collapsedNodes.add(id);
        return null;
    }

    public Object expandNode(Map<String, String[]> params) {
        String id = params.get("formulaId")[0];
        this.collapsedNodes.remove(id);
        return null;
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "FormulaView.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "FormulaView.enable"));
        }
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        Object data;
        this.sendInitMessage(context);
        if (this.currentStateSpace != null && (data = this.calculateData()) != null) {
            this.submit(WebUtils.wrap("cmd", "FormulaView.formulaSet", "formula", this.formula.getCode(), "unicode", StringEscapeUtils.escapeHtml((String)UnicodeTranslator.toUnicode((String)this.formula.getCode())), "data", data));
        }
    }
}

