/*
 * Decompiled with CFR 0.152.
 */
package de.prob.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import de.prob.annotations.Home;
import de.prob.annotations.Logfile;
import de.prob.annotations.Version;
import de.prob.servlet.Main;
import de.prob.servlet.MainModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.pegdown.PegDownProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainConfiguration
extends AbstractModule {
    private final Properties buildConstants;
    private final Logger logger = LoggerFactory.getLogger(MainConfiguration.class);

    public MainConfiguration() {
        this.buildConstants = this.loadBuildConstants();
    }

    protected void configure() {
        this.bind(CommandLineParser.class).to(PosixParser.class);
        this.bind(String.class).annotatedWith(Version.class).toInstance((Object)this.buildConstants.getProperty("version", "0.0.0"));
        this.bind(ClassLoader.class).annotatedWith((Annotation)Names.named((String)"Classloader")).toInstance((Object)Main.class.getClassLoader());
        this.bind(PegDownProcessor.class);
        System.setProperty("PROB_LOGFILE", this.getProBLogfile());
    }

    @Provides
    @Home
    public final String getProBDirectory() {
        return Main.getProBDirectory();
    }

    @Provides
    @Logfile
    public final String getProBLogfile() {
        return this.getProBDirectory() + "logs" + File.separator + "ProB.txt";
    }

    @Provides
    public final Options getCommandlineOptions() {
        Options options = new Options();
        Option shell = new Option("s", "shell", false, "start ProB's Groovy shell");
        Option restricted = new Option("local", "Free access to Groovy shell. Interface will be bound to 127.0.0.1");
        Option standalone = new Option("standalone", "Run in standalone mode");
        Option animation = new Option("multianimation", "UI components will have the capability to show multiple animations at once (NOTE: the development of this option is in the experimental phase)");
        OptionBuilder.withArgName((String)"maxSize");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set the cache size for the states in the StateSpace");
        Option maxCacheSize = OptionBuilder.create((String)"maxCacheSize");
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Open URL in browser");
        Option browser = OptionBuilder.create((String)"browser");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set specific port for UI");
        Option port = OptionBuilder.create((String)"port");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.withDescription((String)"upgrade the ProB binaries. Optionally specify the desired version.");
        Option upgrade = OptionBuilder.create((String)"upgrade");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.withDescription((String)"upgrade the ProB binaries before starting the shell. Optionally specify the desired version.");
        Option upgrade2 = OptionBuilder.create((String)"cli");
        OptionGroup mode = new OptionGroup();
        mode.setRequired(true);
        mode.addOption(shell);
        mode.addOption(upgrade);
        options.addOptionGroup(mode);
        options.addOption(browser);
        options.addOption(port);
        options.addOption(restricted);
        options.addOption(standalone);
        options.addOption(upgrade2);
        options.addOption(animation);
        options.addOption(maxCacheSize);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadBuildConstants() {
        ClassLoader classLoader = MainModule.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream("build.properties");
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            this.logger.debug("Could not load build.properties.", (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                this.logger.debug("Could not close stream.", (Throwable)e);
            }
        }
        return properties;
    }
}

