/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.IOException;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.SpecRunHistory;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.RunnerConfiguration;

public class OptimizeRunOrderExtension
implements IGlobalExtension {
    private RunnerConfiguration configuration;

    public void visitSpec(SpecInfo spec) {
        if (!this.configuration.optimizeRunOrder) {
            return;
        }
        final SpecRunHistory history = new SpecRunHistory(((Class)spec.getReflection()).getName());
        this.safeLoadFromDisk(history);
        history.sortFeatures(spec);
        spec.addListener(new AbstractRunListener(){
            long specStarted;
            long featureStarted;
            boolean errorOccurred;

            public void beforeSpec(SpecInfo spec) {
                this.specStarted = System.nanoTime();
            }

            public void beforeFeature(FeatureInfo feature) {
                this.featureStarted = System.nanoTime();
                this.errorOccurred = false;
            }

            public void afterFeature(FeatureInfo feature) {
                history.collectFeatureData(feature, System.nanoTime() - this.featureStarted, this.errorOccurred);
            }

            public void error(ErrorInfo error) {
                this.errorOccurred = true;
            }

            public void afterSpec(SpecInfo spec) {
                history.collectSpecData(spec, System.nanoTime() - this.specStarted);
                OptimizeRunOrderExtension.this.safeSaveToDisk(history);
            }
        });
    }

    private void safeLoadFromDisk(SpecRunHistory history) {
        try {
            history.loadFromDisk();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void safeSaveToDisk(SpecRunHistory history) {
        try {
            history.saveToDisk();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

