/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.List;
import java.util.ListIterator;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.HamcrestFacade;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.util.CollectionUtil;
import spock.util.matcher.HamcrestSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpockRuntime {
    public static final String VERIFY_CONDITION = "verifyCondition";
    public static final String VERIFY_METHOD_CONDITION = "verifyMethodCondition";
    public static final String DESPREAD_LIST = "despreadList";

    public static void verifyCondition(ValueRecorder recorder, String text, int line, int column, Object message, Object condition) {
        if (!GroovyRuntimeUtil.isTruthy(condition)) {
            throw new ConditionNotSatisfiedError(new Condition(SpockRuntime.getValues(recorder), text, TextPosition.create(line, column), SpockRuntime.messageToString(message)));
        }
    }

    public static void verifyMethodCondition(ValueRecorder recorder, String text, int line, int column, Object message, Object target, String method, Object[] args, boolean safe, boolean explicit) {
        Object result;
        MatcherCondition matcherCondition = MatcherCondition.parse(target, method, args, safe);
        if (matcherCondition != null) {
            matcherCondition.verify(SpockRuntime.getValues(recorder), text, line, column, SpockRuntime.messageToString(message));
            return;
        }
        Object object = result = safe ? GroovyRuntimeUtil.invokeMethodNullSafe(target, method, args) : GroovyRuntimeUtil.invokeMethod(target, method, args);
        if (!explicit && result == null && GroovyRuntimeUtil.isVoidMethod(target, method, args)) {
            return;
        }
        if (!GroovyRuntimeUtil.isTruthy(result)) {
            List<Object> values = SpockRuntime.getValues(recorder);
            if (values != null) {
                CollectionUtil.setLastElement(values, result);
            }
            throw new ConditionNotSatisfiedError(new Condition(values, text, TextPosition.create(line, column), SpockRuntime.messageToString(message)));
        }
    }

    public static Object[] despreadList(Object[] args, Object[] spreads, int[] positions) {
        return GroovyRuntimeUtil.despreadList(args, spreads, positions);
    }

    private static List<Object> getValues(ValueRecorder recorder) {
        return recorder == null ? null : recorder.getValues();
    }

    private static String messageToString(Object message) {
        if (message == null) {
            return null;
        }
        return GroovyRuntimeUtil.toString(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatcherCondition {
        final Object actual;
        final Object matcher;
        final boolean shortSyntax;

        MatcherCondition(Object actual, Object matcher, boolean shortSyntax) {
            this.actual = actual;
            this.matcher = matcher;
            this.shortSyntax = shortSyntax;
        }

        void verify(List<Object> values, String text, int line, int column, String message) {
            if (HamcrestFacade.matches(this.matcher, this.actual)) {
                return;
            }
            if (values != null) {
                CollectionUtil.setLastElement(values, this.shortSyntax ? this.actual : Boolean.valueOf(false));
                this.replaceMatcherValues(values);
            }
            String description = HamcrestFacade.getFailureDescription(this.matcher, this.actual, message);
            Condition condition = new Condition(values, text, TextPosition.create(line, column), description);
            throw new ConditionNotSatisfiedError(condition);
        }

        void replaceMatcherValues(List<Object> values) {
            boolean firstOccurrence = true;
            ListIterator<Object> iter = values.listIterator(values.size());
            while (iter.hasPrevious()) {
                Object value = iter.previous();
                if (!HamcrestFacade.isMatcher(value)) continue;
                if (firstOccurrence) {
                    iter.set(this.shortSyntax ? Boolean.valueOf(false) : ExpressionInfo.VALUE_NOT_AVAILABLE);
                    firstOccurrence = false;
                    continue;
                }
                iter.set(ExpressionInfo.VALUE_NOT_AVAILABLE);
            }
        }

        static MatcherCondition parse(Object target, String method, Object[] args, boolean safe) {
            if (safe) {
                return null;
            }
            if (method.equals("call")) {
                if (args.length != 1 || !HamcrestFacade.isMatcher(args[0])) {
                    return null;
                }
                return new MatcherCondition(target, args[0], true);
            }
            if (method.equals("that") || method.equals("expect")) {
                if (target != HamcrestSupport.class) {
                    return null;
                }
                if (args.length != 2 || !HamcrestFacade.isMatcher(args[1])) {
                    return null;
                }
                return new MatcherCondition(args[0], args[1], false);
            }
            return null;
        }
    }
}

