/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.extension.CycleError;

public class Closure<T> {
    private final Map<T, Set<T>> reachable = new HashMap<T, Set<T>>();
    private final Map<T, Set<T>> reachableReverse = new HashMap<T, Set<T>>();

    public Map<T, Set<T>> getRelationMap() {
        return Collections.unmodifiableMap(this.reachable);
    }

    public boolean contains(T a, T b) {
        return Closure.contains(this.reachable, a, b);
    }

    public void add(T a, T b) throws CycleError {
        Closure.add(this.reachable, a, b);
        Closure.addAll(this.reachable, a, Closure.get(this.reachable, b));
        Closure.add(this.reachableReverse, b, a);
        Closure.addAll(this.reachableReverse, b, Closure.get(this.reachableReverse, a));
        if (!a.equals(b) && Closure.contains(this.reachableReverse, a, b)) {
            throw new CycleError("Adding " + a + "|->" + b + " makes a cycle.");
        }
        for (T e : Closure.get(this.reachableReverse, a)) {
            Closure.addAll(this.reachable, e, Closure.get(this.reachable, a));
        }
        for (T e : Closure.get(this.reachable, b)) {
            Closure.addAll(this.reachableReverse, e, Closure.get(this.reachableReverse, b));
        }
    }

    private static <T> void add(Map<T, Set<T>> map, T a, T b) {
        Set<T> set = Closure.get(map, a, true);
        set.add(b);
    }

    private static <T> Set<T> get(Map<T, Set<T>> map, T a, boolean addIfNeeded) {
        Set<T> set = map.get(a);
        if (set == null) {
            set = new HashSet<T>();
            if (addIfNeeded) {
                map.put(a, set);
            }
        }
        return set;
    }

    private static <T> void addAll(Map<T, Set<T>> map, T a, Set<T> s) {
        Set<T> set = Closure.get(map, a, true);
        set.addAll(s);
    }

    private static <T> Set<T> get(Map<T, Set<T>> map, T a) {
        return Closure.get(map, a, false);
    }

    private static <T> boolean contains(Map<T, Set<T>> map, T a, T b) {
        return Closure.get(map, a).contains(b);
    }

    public String toString() {
        return this.reachable.toString();
    }
}

