/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.lexer.Scanner;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.MainParsers;
import org.eventb.internal.core.parser.ParseResult;
import org.eventb.internal.core.parser.ParserContext;

public class GenParser {
    private static final boolean DEBUG = false;
    private final Scanner scanner;
    private final Class<?> clazz;
    private final FormulaFactory factory;
    private final ParseResult result;
    private final boolean withPredVar;

    public GenParser(Class<?> clazz, Scanner scanner, ParseResult result, boolean withPredVar) {
        this.scanner = scanner;
        this.clazz = clazz;
        this.result = result;
        this.factory = result.factory;
        this.withPredVar = withPredVar;
    }

    public void parse() {
        ParserContext pc = new ParserContext(this.scanner, this.factory, this.result, this.withPredVar);
        try {
            Object res;
            pc.init();
            if (this.clazz == Type.class) {
                res = pc.subParse(MainParsers.TYPE_PARSER, false);
                this.result.setParsedType((Type)res);
            } else if (this.clazz == Assignment.class) {
                res = pc.subParse(MainParsers.ASSIGNMENT_PARSER, false);
                this.result.setParsedAssignment((Assignment)res);
            } else if (this.clazz == Predicate.class) {
                res = pc.subParse(MainParsers.PRED_PARSER, false);
                this.result.setParsedPredicate((Predicate)res);
            } else if (this.clazz == Expression.class) {
                res = pc.subParse(MainParsers.EXPR_PARSER, false);
                this.result.setParsedExpression((Expression)res);
            } else {
                throw new IllegalArgumentException("Can only parse one of: Predicate, Expression, Assignment or Type.");
            }
            int eof = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.EOF);
            if (pc.t.kind != eof) {
                this.failUnmatchedTokens(pc);
            }
        }
        catch (SyntaxError e) {
            this.processFailure(pc.takeProblem());
        }
    }

    private void failUnmatchedTokens(ParserContext pc) {
        int startPos = pc.t.pos;
        pc.scanUntilEOF();
        int endPos = pc.t.pos - 1;
        this.processFailure(new ASTProblem(pc.makeSourceLocation(startPos, endPos), ProblemKind.UnmatchedTokens, 1, new Object[0]));
    }

    private void processFailure(ASTProblem problem) {
        this.result.addProblem(problem);
        this.result.resetParsedFormula();
    }

    public ParseResult getResult() {
        return this.result;
    }

    static enum ProgressDirection {
        LEFT,
        RIGHT;

    }

    public static class SyntaxError
    extends Exception {
        private static final long serialVersionUID = -8349775303104088736L;
        private static final SyntaxError SYNTAX_ERROR = new SyntaxError();

        private SyntaxError() {
        }

        public static SyntaxError getInstance() {
            return SYNTAX_ERROR;
        }
    }

    public static class OverrideException
    extends Exception {
        private static final long serialVersionUID = -1281802568424261959L;

        public OverrideException(String reason) {
            super(reason);
        }
    }
}

