/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.lexer;

import org.eventb.core.ast.FormulaFactory;
import org.eventb.internal.core.lexer.GenLexer;
import org.eventb.internal.core.lexer.LexStream;
import org.eventb.internal.core.parser.AbstractGrammar;

public enum LexicalClass {
    IDENTIFIER{

        private boolean isExcluded(int codePoint) {
            return codePoint == 955 || codePoint == 36;
        }

        @Override
        public boolean isStart(int codePoint) {
            return Character.isJavaIdentifierStart(codePoint) && !this.isExcluded(codePoint);
        }

        @Override
        public boolean isPart(int codePoint) {
            return Character.isJavaIdentifierPart(codePoint) && !this.isExcluded(codePoint);
        }

        @Override
        public int getKind(String image, AbstractGrammar grammar) {
            int kind = grammar.getTokens().getKind(image);
            if (kind == -1) {
                return grammar.getKind(AbstractGrammar.DefaultToken.IDENT);
            }
            return kind;
        }
    }
    ,
    SYMBOL{

        @Override
        public boolean isStart(int codePoint) {
            return !IDENTIFIER.isStart(codePoint) && !WHITESPACE.isStart(codePoint) && !INTEGER_LITERAL.isStart(codePoint) && !META_VAR.isStart(codePoint);
        }

        @Override
        public boolean isPart(int codePoint) {
            return !IDENTIFIER.isPart(codePoint) && !WHITESPACE.isPart(codePoint);
        }

        @Override
        public int getKind(String image, AbstractGrammar grammar) {
            return grammar.getTokens().getKind(image);
        }

        @Override
        public boolean read(LexStream stream, AbstractGrammar grammar) {
            int lastAccepted = -1;
            if (this.isKnownSymbol(stream, grammar)) {
                lastAccepted = stream.getCurPos();
            }
            while (!stream.isEOF() && this.isPart(stream.curCodePoint())) {
                stream.goForward();
                if (!this.isKnownSymbol(stream, grammar)) continue;
                lastAccepted = stream.getCurPos();
            }
            if (lastAccepted == -1) {
                stream.resetCurPos();
                return false;
            }
            stream.setCurPos(lastAccepted);
            return true;
        }

        private boolean isKnownSymbol(LexStream stream, AbstractGrammar grammar) {
            return grammar.getTokens().contains(stream.getLexem());
        }
    }
    ,
    WHITESPACE{

        @Override
        public boolean isStart(int codePoint) {
            return 3.isWhitespace(codePoint);
        }

        @Override
        public boolean isPart(int codePoint) {
            return 3.isWhitespace(codePoint);
        }

        @Override
        public int getKind(String image, AbstractGrammar grammar) {
            assert (false);
            return grammar.getKind(AbstractGrammar.DefaultToken.EOF);
        }
    }
    ,
    INTEGER_LITERAL{

        @Override
        public boolean isStart(int codePoint) {
            return 4.isDigit(codePoint);
        }

        @Override
        public boolean isPart(int codePoint) {
            return 4.isDigit(codePoint);
        }

        @Override
        public int getKind(String image, AbstractGrammar grammar) {
            return grammar.getKind(AbstractGrammar.DefaultToken.INT_LIT);
        }
    }
    ,
    META_VAR{

        @Override
        public boolean isStart(int codePoint) {
            return codePoint == 36;
        }

        @Override
        public boolean isPart(int codePoint) {
            assert (false);
            return false;
        }

        @Override
        public int getKind(String image, AbstractGrammar grammar) {
            return grammar.getKind(AbstractGrammar.DefaultToken.PRED_VAR);
        }

        @Override
        public boolean read(LexStream stream, AbstractGrammar grammar) {
            if (stream.isEOF()) {
                return false;
            }
            GenLexer.LexemReader reader = new GenLexer.LexemReader(grammar);
            int metaStart = stream.getTokenStart();
            LexicalClass lexClass = reader.read(stream);
            stream.setTokenStart(metaStart);
            return lexClass == IDENTIFIER;
        }
    };

    private static final LexicalClass[] OPTIMIZED_ORDER;

    protected static boolean isWhitespace(int codePoint) {
        return Character.isWhitespace(codePoint) || FormulaFactory.isEventBWhiteSpace(codePoint);
    }

    protected static boolean isDigit(int codePoint) {
        return Character.isDigit(codePoint);
    }

    public abstract boolean isStart(int var1);

    public abstract boolean isPart(int var1);

    public abstract int getKind(String var1, AbstractGrammar var2);

    public boolean read(LexStream stream, AbstractGrammar grammar) {
        while (!stream.isEOF() && this.isPart(stream.curCodePoint())) {
            stream.goForward();
        }
        return true;
    }

    public boolean contains(String str) {
        int start;
        if (str.isEmpty()) {
            return false;
        }
        if (!this.isStart(str.codePointAt(0))) {
            return false;
        }
        int i = start = LexStream.nextCodePoint(str, 0);
        while (i < str.length()) {
            if (!this.isPart(str.codePointAt(i))) {
                return false;
            }
            i = LexStream.nextCodePoint(str, i);
        }
        return true;
    }

    public static LexicalClass getLexicalClass(int startCodePoint) {
        for (LexicalClass lexClass : OPTIMIZED_ORDER) {
            if (!lexClass.isStart(startCodePoint)) continue;
            return lexClass;
        }
        return SYMBOL;
    }

    static {
        OPTIMIZED_ORDER = new LexicalClass[]{IDENTIFIER, WHITESPACE, INTEGER_LITERAL, META_VAR};
    }
}

