/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.internal.core.ast.Substitute;
import org.eventb.internal.core.ast.Substitution;

public class SimpleSubstitution
extends Substitution {
    protected Map<FreeIdentifier, Substitute> map;

    protected SimpleSubstitution(FormulaFactory ff) {
        super(ff);
    }

    public SimpleSubstitution(Map<FreeIdentifier, Expression> map, FormulaFactory ff) {
        super(ff);
        this.map = new HashMap<FreeIdentifier, Substitute>(map.size() * 4 / 3 + 1);
        for (Map.Entry<FreeIdentifier, Expression> entry : map.entrySet()) {
            FreeIdentifier ident = entry.getKey();
            Expression expr = entry.getValue();
            assert (ident.getType() == null || ident.getType().equals(expr.getType()));
            this.map.put(entry.getKey(), Substitute.makeSubstitute(entry.getValue()));
        }
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Expression rewrite(FreeIdentifier ident) {
        Substitute repl = this.map.get(ident);
        if (repl == null) {
            return super.rewrite(ident);
        }
        return repl.getSubstitute(ident, this.getBindingDepth());
    }
}

