/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.AssociativeHelper;
import org.eventb.core.ast.DefaultVisitor;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.typecheck.TypeUnifier;

class ExtensionHelper {
    ExtensionHelper() {
    }

    public static Formula<?>[] concat(Expression[] expressions, Predicate[] predicates) {
        int i;
        Formula[] children = new Formula[expressions.length + predicates.length];
        for (i = 0; i < expressions.length; ++i) {
            children[i] = expressions[i];
        }
        for (i = 0; i < predicates.length; ++i) {
            children[expressions.length + i] = predicates[i];
        }
        return children;
    }

    public static void solveTypes(TypeUnifier unifier, Expression[] expressions, Predicate[] predicates) {
        for (Expression expression : expressions) {
            expression.solveType(unifier);
        }
        for (Formula formula : predicates) {
            ((Predicate)formula).solveType(unifier);
        }
    }

    public static void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet, Expression[] expressions, Predicate[] predicates) {
        for (Expression expression : expressions) {
            expression.collectFreeIdentifiers(freeIdentSet);
        }
        for (Formula formula : predicates) {
            formula.collectFreeIdentifiers(freeIdentSet);
        }
    }

    public static void collectNamesAbove(Set<String> names, String[] boundNames, int offset, Expression[] expressions, Predicate[] predicates) {
        for (Expression expression : expressions) {
            expression.collectNamesAbove(names, boundNames, offset);
        }
        for (Formula formula : predicates) {
            formula.collectNamesAbove(names, boundNames, offset);
        }
    }

    public static Formula<?> getChild(Expression[] exprs, Predicate[] preds, int index) {
        if (index < 0 || index >= ExtensionHelper.getChildCount(exprs, preds)) {
            throw Formula.invalidIndex(index);
        }
        if (index < exprs.length) {
            return exprs[index];
        }
        return preds[index - exprs.length];
    }

    public static int getChildCount(Expression[] exprs, Predicate[] preds) {
        return exprs.length + preds.length;
    }

    public static <T extends Formula<T>, U extends Formula<U>> IPosition getDescendantPos(T[] children1, U[] children2, SourceLocation sloc, IntStack indexes) {
        IPosition pos;
        indexes.push(0);
        for (Object child : children1) {
            pos = ((Formula)child).getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        for (Object child : children2) {
            pos = ((Formula)child).getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        indexes.pop();
        return new Position(indexes);
    }

    public static <T extends Formula<T>, U extends Formula<U>> void isLegible(T[] array1, U[] array2, LegibilityResult result) {
        AssociativeHelper.isLegibleList(array1, (LegibilityResult)result);
        AssociativeHelper.isLegibleList(array2, (LegibilityResult)result);
    }

    public static IParserPrinter<? extends Formula<?>> makeParserPrinter(Formula<?> formula, IFormulaExtension extension, IToStringMediator mediator) {
        IOperatorProperties properties = extension.getKind().getProperties();
        String opId = extension.getId();
        String groupId = extension.getGroupId();
        String syntaxSymbol = extension.getSyntaxSymbol();
        AbstractGrammar grammar = mediator.getGrammar();
        IOperatorInfo<Formula<?>> opInfo = grammar.getParser(properties, syntaxSymbol, formula.getTag(), opId, groupId);
        return opInfo.makeParser(mediator.getKind());
    }

    public static <F> void inspectChildren(FindingAccumulator<F> acc, Expression[] childExpressions, Predicate[] childPredicates) {
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (Expression expression : childExpressions) {
            expression.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        if (!acc.allSkipped()) {
            for (Formula formula : childPredicates) {
                formula.inspect(acc);
                if (acc.allSkipped()) break;
                acc.nextChild();
            }
        }
        acc.leaveChildren();
    }

    public static class ExtensionGatherer
    extends DefaultVisitor {
        private final Set<IFormulaExtension> extensions;

        public ExtensionGatherer(Set<IFormulaExtension> extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean enterExtendedExpression(ExtendedExpression expression) {
            this.extensions.add(expression.getExtension());
            return true;
        }

        @Override
        public boolean enterExtendedPredicate(ExtendedPredicate predicate) {
            this.extensions.add(predicate.getExtension());
            return true;
        }
    }
}

