/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.BigInt;
import com.github.krukow.clj_lang.IHashEq;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.Numbers;
import com.github.krukow.clj_lang.PersistentVector;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static EquivPred equivNull = new EquivPred(){

        public boolean equiv(Object k1, Object k2) {
            return k2 == null;
        }
    };
    static EquivPred equivEquals = new EquivPred(){

        public boolean equiv(Object k1, Object k2) {
            return k1.equals(k2);
        }
    };
    static EquivPred equivNumber = new EquivPred(){

        public boolean equiv(Object k1, Object k2) {
            if (k2 instanceof Number) {
                return Numbers.equal((Number)k1, (Number)k2);
            }
            return false;
        }
    };
    static EquivPred equivColl = new EquivPred(){

        public boolean equiv(Object k1, Object k2) {
            if (k1 instanceof IPersistentCollection || k2 instanceof IPersistentCollection) {
                return Util.pcequiv(k1, k2);
            }
            return k1.equals(k2);
        }
    };

    public static boolean equiv(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        if (k1 != null) {
            if (k1 instanceof Number && k2 instanceof Number) {
                return Numbers.equal((Number)k1, (Number)k2);
            }
            if (k1 instanceof IPersistentCollection || k2 instanceof IPersistentCollection) {
                return Util.pcequiv(k1, k2);
            }
            return k1.equals(k2);
        }
        return false;
    }

    public static EquivPred equivPred(Object k1) {
        if (k1 == null) {
            return equivNull;
        }
        if (k1 instanceof Number) {
            return equivNumber;
        }
        if (k1 instanceof String) {
            return equivEquals;
        }
        if (k1 instanceof Collection || k1 instanceof Map) {
            return equivColl;
        }
        return equivEquals;
    }

    public static boolean equiv(long k1, long k2) {
        return k1 == k2;
    }

    public static boolean equiv(Object k1, long k2) {
        return Util.equiv(k1, (Object)k2);
    }

    public static boolean equiv(long k1, Object k2) {
        return Util.equiv((Object)k1, k2);
    }

    public static boolean equiv(double k1, double k2) {
        return k1 == k2;
    }

    public static boolean equiv(Object k1, double k2) {
        return Util.equiv(k1, (Object)k2);
    }

    public static boolean equiv(double k1, Object k2) {
        return Util.equiv((Object)k1, k2);
    }

    public static boolean equiv(boolean k1, boolean k2) {
        return k1 == k2;
    }

    public static boolean equiv(Object k1, boolean k2) {
        return Util.equiv(k1, (Object)k2);
    }

    public static boolean equiv(boolean k1, Object k2) {
        return Util.equiv((Object)k1, k2);
    }

    public static boolean equiv(char c1, char c2) {
        return c1 == c2;
    }

    public static boolean pcequiv(Object k1, Object k2) {
        if (k1 instanceof IPersistentCollection) {
            return ((IPersistentCollection)k1).equiv(k2);
        }
        return ((IPersistentCollection)k2).equiv(k1);
    }

    public static boolean equals(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        return k1 != null && k1.equals(k2);
    }

    public static boolean identical(Object k1, Object k2) {
        return k1 == k2;
    }

    public static Class classOf(Object x) {
        if (x != null) {
            return x.getClass();
        }
        return null;
    }

    public static int compare(Object k1, Object k2) {
        if (k1 == k2) {
            return 0;
        }
        if (k1 != null) {
            if (k2 == null) {
                return 1;
            }
            if (k1 instanceof Number) {
                return Numbers.compare((Number)k1, (Number)k2);
            }
            return ((Comparable)k1).compareTo(k2);
        }
        return -1;
    }

    public static int hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static int hasheq(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof IHashEq) {
            return Util.dohasheq((IHashEq)o);
        }
        if (o instanceof Number) {
            return Numbers.hasheq((Number)o);
        }
        return o.hashCode();
    }

    private static int dohasheq(IHashEq o) {
        return o.hasheq();
    }

    public static int hashCombine(int seed, int hash) {
        seed ^= hash + -1640531527 + (seed << 6) + (seed >> 2);
        return seed;
    }

    public static boolean isPrimitive(Class c) {
        return c != null && c.isPrimitive() && c != Void.TYPE;
    }

    public static boolean isInteger(Object x) {
        return x instanceof Integer || x instanceof Long || x instanceof BigInt || x instanceof BigInteger;
    }

    public static Object ret1(Object ret, Object nil) {
        return ret;
    }

    public static PersistentVector.Node ret1(PersistentVector.Node ret, Object nil) {
        return ret;
    }

    public static Object[] ret1(Object[] ret, Object nil) {
        return ret;
    }

    public static ISeq ret1(ISeq ret, Object nil) {
        return ret;
    }

    public static <K, V> void clearCache(ReferenceQueue rq, ConcurrentHashMap<K, Reference<V>> cache) {
        if (rq.poll() != null) {
            while (rq.poll() != null) {
            }
            for (Map.Entry<K, Reference<V>> e : cache.entrySet()) {
                Reference<V> val = e.getValue();
                if (val == null || val.get() != null) continue;
                cache.remove(e.getKey(), val);
            }
        }
    }

    public static RuntimeException runtimeException(String s) {
        return new RuntimeException(s);
    }

    public static RuntimeException runtimeException(String s, Throwable e) {
        return new RuntimeException(s, e);
    }

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        Util.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    public static interface EquivPred {
        public boolean equiv(Object var1, Object var2);
    }
}

