/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.IPersistentList;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IReduce;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.Obj;
import com.github.krukow.clj_lang.PersistentVector;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Sequential;
import com.github.krukow.clj_lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentList<T>
extends ASeq<T>
implements IPersistentList<T>,
IReduce,
List<T>,
Counted,
com.github.krukow.clj_ds.PersistentList<T> {
    private final T _first;
    private final PersistentList<T> _rest;
    private final int _count;
    public static final EmptyList EMPTY = new EmptyList(null);

    public static final <T> EmptyList<T> emptyList() {
        return EMPTY;
    }

    public PersistentList(T first) {
        this._first = first;
        this._rest = null;
        this._count = 1;
    }

    PersistentList(IPersistentMap meta, T _first, PersistentList<T> _rest, int _count) {
        super(meta);
        this._first = _first;
        this._rest = _rest;
        this._count = _count;
    }

    public static <T> com.github.krukow.clj_ds.PersistentList<T> create(T ... init) {
        IPersistentList<T> ret = PersistentList.emptyList();
        for (int i = init.length - 1; i >= 0; --i) {
            ret = (IPersistentList)ret.cons(init[i]);
        }
        return ret;
    }

    public static <T> com.github.krukow.clj_ds.PersistentList<T> create(Iterable<? extends T> init) {
        PersistentVector<? extends T> initVector = PersistentVector.create(init);
        return (com.github.krukow.clj_ds.PersistentList)((Object)PersistentList.create(initVector));
    }

    public static <T> IPersistentList<T> create(List<? extends T> init) {
        IPersistentList<T> ret = PersistentList.emptyList();
        ListIterator<T> i = init.listIterator(init.size());
        while (i.hasPrevious()) {
            ret = (IPersistentList)ret.cons(i.previous());
        }
        return ret;
    }

    @Override
    public T first() {
        return this._first;
    }

    @Override
    public ISeq<T> next() {
        if (this._count == 1) {
            return null;
        }
        return this._rest;
    }

    @Override
    public T peek() {
        return this.first();
    }

    @Override
    public IPersistentList<T> pop() {
        if (this._rest == null) {
            return EMPTY.withMeta(this._meta);
        }
        return this._rest;
    }

    @Override
    public int count() {
        return this._count;
    }

    @Override
    public PersistentList<T> cons(T o) {
        return new PersistentList<T>(this.meta(), o, this, this._count + 1);
    }

    @Override
    public EmptyList<T> empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentList<T> withMeta(IPersistentMap meta) {
        if (meta != this._meta) {
            return new PersistentList<T>(meta, this._first, this._rest, this._count);
        }
        return this;
    }

    @Override
    public Object reduce(IFn f) {
        Object ret = this.first();
        for (ISeq<T> s = this.next(); s != null; s = s.next()) {
            ret = f.invoke(ret, s.first());
        }
        return ret;
    }

    @Override
    public Object reduce(IFn f, Object start) {
        Object ret = f.invoke(start, this.first());
        for (ISeq<T> s = this.next(); s != null; s = s.next()) {
            ret = f.invoke(ret, s.first());
        }
        return ret;
    }

    public static <T> com.github.krukow.clj_ds.PersistentList<T> consAll(com.github.krukow.clj_ds.PersistentList<T> list, Iterable<? extends T> others) {
        for (T other : others) {
            list = list.plus(other);
        }
        return list;
    }

    @Override
    public com.github.krukow.clj_ds.PersistentList<T> zero() {
        return this.empty();
    }

    @Override
    public com.github.krukow.clj_ds.PersistentList<T> plus(T val) {
        return this.cons((Object)val);
    }

    @Override
    public com.github.krukow.clj_ds.PersistentList<T> minus() {
        return (com.github.krukow.clj_ds.PersistentList)((Object)this.pop());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyList<T>
    extends Obj
    implements IPersistentList<T>,
    List<T>,
    ISeq<T>,
    Counted,
    com.github.krukow.clj_ds.PersistentList<T> {
        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
        }

        @Override
        public boolean equiv(Object o) {
            return this.equals(o);
        }

        EmptyList(IPersistentMap meta) {
            super(meta);
        }

        @Override
        public T first() {
            return null;
        }

        @Override
        public ISeq<T> next() {
            return null;
        }

        @Override
        public ISeq<T> more() {
            return this;
        }

        @Override
        public PersistentList<T> cons(T o) {
            return new PersistentList<T>(this.meta(), o, null, 1);
        }

        @Override
        public EmptyList<T> empty() {
            return this;
        }

        @Override
        public EmptyList<T> withMeta(IPersistentMap meta) {
            if (meta != this.meta()) {
                return new EmptyList<T>(meta);
            }
            return this;
        }

        @Override
        public T peek() {
            return null;
        }

        @Override
        public PersistentList<T> pop() {
            throw new IllegalStateException("Can't pop empty list");
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public ISeq<T> seq() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return RT.EMPTY_ARRAY;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray(Object[] objects) {
            if (objects.length > 0) {
                objects[0] = null;
            }
            return objects;
        }

        private List<T> reify() {
            return Collections.unmodifiableList(new ArrayList(this));
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.reify().subList(fromIndex, toIndex);
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            ISeq<T> s = this.seq();
            int i = 0;
            while (s != null) {
                if (Util.equiv(s.first(), o)) {
                    return i;
                }
                s = s.next();
                ++i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.reify().lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.reify().listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.reify().listIterator(index);
        }

        @Override
        public T get(int index) {
            return (T)RT.nth(this, index);
        }

        @Override
        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public com.github.krukow.clj_ds.PersistentList<T> zero() {
            return this;
        }

        @Override
        public com.github.krukow.clj_ds.PersistentList<T> plus(T val) {
            return this.cons((Object)val);
        }

        @Override
        public com.github.krukow.clj_ds.PersistentList<T> minus() {
            return this.pop();
        }
    }
}

