/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.io.File;
import java.io.IOException;
import tla2tex.BuiltInSymbols;
import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.ExecuteCommand;
import tla2tex.FileCharReader;
import tla2tex.FindAlignments;
import tla2tex.FormatComments;
import tla2tex.LaTeXOutput;
import tla2tex.Misc;
import tla2tex.Parameters;
import tla2tex.ResourceFileReader;
import tla2tex.TLA2TexException;
import tla2tex.Token;
import tla2tex.TokenizeSpec;
import tla2tex.WriteTLAFile;
import util.FileUtil;
import util.ToolIO;

public class TLA {
    static final String lastModified = "last modified on Wed  12 Apr 2013 at 16:06:38 PST by lamport";
    static String modDate = "last modified on Wed  12 Apr 2013 at 16:06:38 PST by lamport".substring(21, 33);
    static String version = "tla2tex.TLA Version 1.0 created " + modDate;
    private static long start = Debug.now();

    public static void main(String[] args) {
        TLA.runTranslation(args);
    }

    public static void runTranslation(String[] args) {
        long startTime = Debug.now();
        ToolIO.out.println(version);
        TLA.GetArguments(args);
        TLA.Starting("BuiltInSymbols.Initialize");
        BuiltInSymbols.Initialize();
        TLA.Finished("BuiltInSymbols.Initialize");
        FileCharReader testlr = new FileCharReader(Parameters.TLAInputFile);
        TLA.Starting("TokenizeSpec.Tokenize");
        Token[][] spec = TokenizeSpec.Tokenize(testlr, 1);
        Token.FindPfStepTokens(spec);
        TLA.Finished("TokenizeSpec.Tokenize");
        TLA.Starting("TokenizeSpec.FixPlusCal");
        TokenizeSpec.FixPlusCal(spec, false);
        TLA.Finished("TokenizeSpec.FixPlusCal");
        TLA.Starting("CommentToken.ProcessComments");
        CommentToken.ProcessComments(spec);
        TLA.Finished("CommentToken.ProcessComments");
        TLA.Starting("FormatComments.Initialize");
        FormatComments.Initialize();
        TLA.Finished("FormatComments.Initialize");
        TLA.Starting("FindAlignments.FindAlignments");
        FindAlignments.FindAlignments(spec);
        TLA.Finished("FindAlignments.FindAlignments");
        if (Parameters.TLAOut) {
            WriteTLAFile.Write(spec, Parameters.TLAOutFile);
            ToolIO.out.println("Wrote -tlaOut file " + Parameters.TLAOutFile);
        }
        TLA.Starting("LaTeXOutput.WriteAlignmentFile");
        LaTeXOutput.WriteAlignmentFile(spec);
        TLA.Finished("LaTeXOutput.WriteAlignmentFile");
        TLA.Starting("LaTeXOutput.RunLaTeX");
        LaTeXOutput.RunLaTeX(Parameters.LaTeXAlignmentFile);
        TLA.Finished("LaTeXOutput.RunLaTeX");
        TLA.Starting("LaTeXOutput.SetDimensions");
        LaTeXOutput.SetDimensions(spec);
        TLA.Finished("LaTeXOutput.SetDimensions");
        TLA.Starting("LaTeXOutput.WriteLaTeXFile");
        LaTeXOutput.WriteLaTeXFile(spec);
        TLA.Finished("LaTeXOutput.WriteLaTeXFile");
        TLA.Starting("LaTeXOutput.RunLaTeX");
        LaTeXOutput.RunLaTeX(Parameters.LaTeXOutputFile);
        TLA.Finished("LaTeXOutput.RunLaTeX");
        ToolIO.out.println("TLATeX " + Parameters.LatexOutputExt + " output written on " + Parameters.LaTeXOutputFile + "." + Parameters.LatexOutputExt + (Parameters.MetaDir.equals("") ? "" : ", from " + Parameters.MetaDir) + ".");
        if (Parameters.PSOutput) {
            TLA.Starting("MakePSFile");
            TLA.MakePSFile();
            TLA.Finished("MakePSFile");
            ToolIO.out.println("TLATeX Postscript (or pdf) output written on " + Parameters.LaTeXOutputFile + ".ps (or " + Parameters.LaTeXOutputFile + ".pdf).");
        }
        if (!Parameters.MetaDir.equals("")) {
            try {
                FileUtil.copyFile(LaTeXOutput.prependMetaDirToFileName(Parameters.LaTeXOutputFile + "." + Parameters.LatexOutputExt), Parameters.TLAInputFile.substring(0, Parameters.TLAInputFile.length() - "tla".length()) + Parameters.LatexOutputExt);
            }
            catch (IOException e) {
                Debug.ReportError("Trying to copy output from metadir produced the error:\n" + e.getMessage());
            }
        }
        Debug.printElapsedTime(startTime, "Total execution time:");
    }

    private static void GetArguments(String[] args) {
        boolean outOption = false;
        boolean alignOutOption = false;
        boolean psOption = false;
        boolean nopsOption = false;
        Parameters.CommentShading = false;
        Parameters.PrintLineNumbers = false;
        int nextArg = 0;
        int maxArg = args.length - 1;
        if (maxArg < 0) {
            TLA.CommandLineError("No arguments specified");
        }
        if (args[maxArg].length() != 0 && args[maxArg].charAt(0) == '-') {
            ++maxArg;
        }
        while (nextArg < maxArg) {
            String option = args[nextArg];
            if (option.equals("-help")) {
                TLA.OutputMessageFile("help.txt");
                System.exit(0);
            } else if (option.equals("-info")) {
                TLA.OutputMessageFile("info.txt");
                System.exit(0);
            } else if (option.equals("-grayLevel")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                try {
                    Parameters.PSGrayLevel = Misc.stringToFloat(args[nextArg]);
                }
                catch (Exception e) {
                    TLA.CommandLineError("Bad -grayLevel value " + args[nextArg]);
                }
                if (Parameters.PSGrayLevel > 1.0f || Parameters.PSGrayLevel < 0.0f) {
                    TLA.CommandLineError("-grayLevel value should be between 0 and 1, not " + Misc.floatToString(Parameters.PSGrayLevel, 3));
                }
            } else if (option.equals("-ps")) {
                psOption = true;
            } else if (option.equals("-nops")) {
                nopsOption = true;
            } else if (option.equals("-psCommand")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                Parameters.PSCommand = args[nextArg];
            } else if (option.equals("-latexCommand")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                Parameters.LaTeXCommand = args[nextArg];
            } else if (option.equals("-out")) {
                outOption = true;
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if (TLA.HasPathPrefix(Parameters.LaTeXOutputFile = TLA.RemoveExtension(args[nextArg]))) {
                    TLA.CommandLineError("-out file contains a path specifier.\nIt must be a file in the current directory.");
                }
            } else if (option.equals("-tlaOut")) {
                Parameters.TLAOut = true;
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if ((Parameters.TLAOutFile = args[nextArg]).indexOf(".") == -1) {
                    Parameters.TLAOutFile = Parameters.TLAOutFile + ".tla";
                }
                if (TLA.HasPathPrefix(Parameters.TLAOutFile)) {
                    TLA.CommandLineError("-tlaOut file contains a path specifier.\nIt must be a file in the current directory.");
                }
            } else if (option.equals("-alignOut")) {
                alignOutOption = true;
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if (TLA.HasPathPrefix(Parameters.LaTeXAlignmentFile = TLA.RemoveExtension(args[nextArg]))) {
                    TLA.CommandLineError("-alignOut file contains a path specifier.\nIt must be a file in the current directory.");
                }
            } else if (option.equals("-debug")) {
                Parameters.Debug = true;
            } else if (option.equals("-tlaComment")) {
                Parameters.TLACommentOption = true;
            } else if (option.equals("-shade")) {
                Parameters.CommentShading = true;
            } else if (option.equals("-noPcalShade")) {
                Parameters.NoPlusCalShading = true;
            } else if (option.equals("-noProlog")) {
                Parameters.PrintProlog = false;
            } else if (option.equals("-noEpilog")) {
                Parameters.PrintEpilog = false;
            } else if (option.equals("-number")) {
                Parameters.PrintLineNumbers = true;
            } else if (option.equals("-style")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if (!(Parameters.UserStyleFile = TLA.RemoveExtension(args[nextArg])).equals(args[nextArg]) && args[nextArg].indexOf(".sty") != args[nextArg].length() - 4) {
                    TLA.CommandLineError("-style file must have extension `.sty'");
                }
            } else if (option.equals("-ptSize")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if ((Parameters.LaTeXptSize = TLA.GetIntArg(args[nextArg], option)) < 10 || Parameters.LaTeXptSize > 12) {
                    TLA.CommandLineError("-ptSize option must be 10, 11, or 12");
                }
            } else if (option.equals("-textwidth")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if ((Parameters.LaTeXtextwidth = TLA.GetIntArg(args[nextArg], option)) < 100 || Parameters.LaTeXtextwidth > 1000) {
                    TLA.CommandLineError("-textwidth value of " + Parameters.LaTeXtextwidth + " points is implausible");
                }
            } else if (option.equals("-textheight")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if ((Parameters.LaTeXtextheight = TLA.GetIntArg(args[nextArg], option)) < 75 || Parameters.LaTeXtextheight > 1500) {
                    TLA.CommandLineError("-textheight value of " + Parameters.LaTeXtextheight + " points is implausible");
                }
            } else if (option.equals("-hoffset")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if ((Parameters.LaTeXhoffset = TLA.GetIntArg(args[nextArg], option)) < -250 || Parameters.LaTeXhoffset > 250) {
                    TLA.CommandLineError("-hoffset value of " + Parameters.LaTeXhoffset + " points is implausible");
                }
            } else if (option.equals("-voffset")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if ((Parameters.LaTeXvoffset = TLA.GetIntArg(args[nextArg], option)) < -250 || Parameters.LaTeXvoffset > 250) {
                    TLA.CommandLineError("-voffset value of " + Parameters.LaTeXvoffset + " points is implausible");
                }
            } else if (option.equals("-metadir")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                if (!(Parameters.ParentDir = new File(Parameters.MetaDir = args[nextArg])).exists()) {
                    TLA.CommandLineError("Specified metdir " + Parameters.MetaDir + " does not exist.");
                }
            } else if (option.equals("-latexOutputExt")) {
                if (++nextArg >= args.length) {
                    TLA.CommandLineError("No input file specified");
                }
                Parameters.LatexOutputExt = args[nextArg];
            } else {
                TLA.CommandLineError("Unknown option: " + option);
            }
            ++nextArg;
        }
        if (nextArg > maxArg) {
            TLA.CommandLineError("No input file specified");
        }
        if (Parameters.TLAOutFile.equals(Parameters.TLAInputFile = args[maxArg].indexOf(".") == -1 ? args[maxArg] + ".tla" : args[maxArg])) {
            TLA.CommandLineError("\n  -tlaOut file the same as the tla input file.\n  This would overwrite your input file, so I won't do it");
        }
        if (!outOption) {
            Parameters.LaTeXOutputFile = TLA.RemoveExtension(TLA.RemovePathPrefix(Parameters.TLAInputFile));
        }
        if (!alignOutOption) {
            Parameters.LaTeXAlignmentFile = Parameters.LaTeXOutputFile;
        }
        if (psOption || Parameters.CommentShading && !nopsOption) {
            Parameters.PSOutput = true;
        }
    }

    private static int GetIntArg(String str, String option) {
        int val = 0;
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            TLA.CommandLineError(option + " option must specify an integer value");
        }
        return val;
    }

    private static String RemoveExtension(String fileName) {
        if (fileName.indexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.indexOf("."));
    }

    private static String RemovePathPrefix(String str) {
        String result = str;
        if (result.indexOf(":") != -1) {
            result = result.substring(result.lastIndexOf(":") + 1);
        }
        if (result.indexOf("/") != -1) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        if (result.indexOf("\\") != -1) {
            result = result.substring(result.lastIndexOf("\\") + 1);
        }
        return result;
    }

    private static boolean HasPathPrefix(String str) {
        return str.indexOf(":") != -1 || str.indexOf("/") != -1 || str.indexOf("\\") != -1;
    }

    private static void CommandLineError(String msg) {
        ToolIO.out.println("TLATeX command-line error: " + msg + ".");
        ToolIO.out.println("Use -help option for more information.");
        throw new TLA2TexException("TLATeX command-line error: " + msg + "." + "Use -help option for more information.");
    }

    private static void OutputMessageFile(String fileName) {
        ResourceFileReader input = new ResourceFileReader(fileName);
        String line = input.getLine();
        while (line != null) {
            ToolIO.out.println(line);
            line = input.getLine();
        }
        input.close();
    }

    private static void Starting(String name) {
        if (Parameters.Debug) {
            start = Debug.now();
            ToolIO.out.println("Starting " + name);
        }
    }

    private static void Finished(String name) {
        if (Parameters.Debug) {
            Debug.printElapsedTime(start, name + " finished in");
        }
    }

    private static void MakePSFile() {
        String Command = Parameters.PSCommand + " " + Parameters.LaTeXOutputFile + ".dvi";
        ExecuteCommand.executeCommand(Command);
    }
}

